/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.core.resource;

import com.google.common.base.Optional;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.infra.emf.readonly.AbstractReadOnlyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOReadOnlyHandler
extends AbstractReadOnlyHandler {
    public CDOReadOnlyHandler(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public Optional<Boolean> anyReadOnly(URI[] uris) {
        Optional result = Optional.absent();
        if (uris.length > 0 && CDOUtils.isCDOEditingDomain(this.getEditingDomain())) {
            int i = 0;
            while (!((Boolean)result.or((Object)Boolean.FALSE)).booleanValue() && i < uris.length) {
                if (CDOUtils.isCDOURI(uris[i])) {
                    result = Optional.of((Object)this.isReadOnly(uris[i]));
                }
                ++i;
            }
        }
        return result;
    }

    protected boolean isReadOnly(URI uri) {
        boolean result = false;
        Resource resource = this.getEditingDomain().getResourceSet().getResource(uri, false);
        if (resource instanceof CDOObject) {
            result = CDOUtils.isReadOnly((CDOObject)resource);
        }
        return result;
    }

    public Optional<Boolean> isReadOnly(EObject eObject) {
        CDOObject cdo;
        Optional result = Optional.absent();
        Resource resource = eObject.eResource();
        if ((resource == null || CDOUtils.isCDOURI(resource.getURI())) && (cdo = CDOUtils.getCDOObject(eObject)) != null) {
            result = Optional.of((Object)CDOUtils.isReadOnly(cdo));
        }
        return result;
    }

    public Optional<Boolean> makeWritable(URI[] uris) {
        return Optional.absent();
    }

    public Optional<Boolean> makeWritable(EObject eObject) {
        return Optional.absent();
    }
}

