/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.core.resource;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.internal.core.l10n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOUndoContext
implements IUndoContext {
    private final Set<EObject> affectedObjects;
    private String cachedLabel;

    public CDOUndoContext(Iterable<? extends EObject> affectedObjects) {
        if (Iterables.isEmpty(affectedObjects)) {
            throw new IllegalArgumentException("affectedObjects is empty");
        }
        this.affectedObjects = ImmutableSet.copyOf(affectedObjects);
    }

    public Set<EObject> getAffectedObjects() {
        return this.affectedObjects;
    }

    public boolean matches(IUndoContext context) {
        return context instanceof CDOUndoContext && !Sets.intersection(this.getAffectedObjects(), ((CDOUndoContext)context).getAffectedObjects()).isEmpty();
    }

    public String getLabel() {
        if (this.cachedLabel == null) {
            StringBuilder buf = new StringBuilder();
            Joiner.on((String)", ").appendTo(buf, Iterables.limit(this.affectedObjects, (int)3));
            if (this.affectedObjects.size() > 3) {
                buf.append(", ...");
            }
            this.cachedLabel = NLS.bind((String)Messages.CDOUndoContext_0, (Object)buf);
        }
        return this.cachedLabel;
    }

    public String toString() {
        return this.getLabel();
    }
}

