/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.core.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class JobWaiter {
    private static final ScheduledExecutorService timeoutService = Executors.newSingleThreadScheduledExecutor();
    private final Object targetFamily;
    private final Job targetJob;
    final long start = System.currentTimeMillis();

    private JobWaiter(Job job, Object family) {
        this.targetJob = job;
        this.targetFamily = family;
    }

    public static boolean waitFor(Object family, long timeout, TimeUnit unit) throws InterruptedException {
        return new JobWaiter(null, family).doWait(timeout, unit);
    }

    public static boolean waitFor(Job job, long timeout, TimeUnit unit) throws InterruptedException {
        return new JobWaiter(job, null).doWait(timeout, unit);
    }

    protected boolean doWait(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result;
        block6: {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("Non-positive timeout");
            }
            result = false;
            Timeout timeoutTask = new Timeout();
            timeoutService.schedule(timeoutTask, timeout, unit);
            try {
                if (this.targetJob != null) {
                    new JobFinishListener(this.targetJob).await();
                } else {
                    Job.getJobManager().join(this.targetFamily, null);
                }
                result = true;
                timeoutTask.cancel();
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
            }
            catch (InterruptedException e) {
                if (timeoutTask.timedOut()) break block6;
                throw e;
            }
        }
        return result;
    }

    private static final class JobFinishListener
    extends JobChangeAdapter {
        private final Job job;
        private boolean done;

        JobFinishListener(Job job) {
            this.job = job;
            Job.getJobManager().addJobChangeListener((IJobChangeListener)this);
        }

        synchronized void await() throws InterruptedException {
            while (!this.done && this.job.getState() == 4) {
                ((Object)((Object)this)).wait();
            }
        }

        public synchronized void done(IJobChangeEvent event) {
            this.done = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    private static class Timeout
    implements Runnable {
        private final Thread toInterrupt = Thread.currentThread();
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final AtomicBoolean timedOut = new AtomicBoolean();

        private Timeout() {
        }

        public void run() {
            if (!this.cancelled.get()) {
                this.timedOut.set(true);
                this.toInterrupt.interrupt();
            }
        }

        void cancel() {
            this.cancelled.set(true);
        }

        boolean timedOut() {
            return this.timedOut.get();
        }
    }
}

