/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.cdo.CDOLock;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.cdo.core.resource.CDOAwareTransactionalEditingDomain;
import org.eclipse.papyrus.cdo.core.util.CDOFunctions;
import org.eclipse.papyrus.cdo.internal.core.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOUtils {
    private static final Set<String> CDO_URI_SCHEMES = ImmutableSet.of((Object)"cdo", (Object)"dawn");
    private static Executor broadcastExecutor = new DirectExecutor();

    private CDOUtils() {
    }

    public static <T> T adapt(Object object, Class<? extends T> type) {
        T result = null;
        if (type.isInstance(object)) {
            result = type.cast(object);
        } else if (object instanceof IAdaptable) {
            result = type.cast(((IAdaptable)object).getAdapter(type));
        }
        return result;
    }

    public static boolean isCDOURI(URI uri) {
        return CDO_URI_SCHEMES.contains(uri.scheme());
    }

    public static boolean isCDOEditingDomain(EditingDomain domain) {
        return domain instanceof CDOAwareTransactionalEditingDomain;
    }

    public static ResourceSet getResourceSet(Notifier notifier) {
        ResourceSet result = null;
        if (notifier instanceof CDOViewSet) {
            result = ((CDOViewSet)notifier).getResourceSet();
        } else if (notifier instanceof ResourceSet) {
            result = (ResourceSet)notifier;
        } else if (notifier instanceof Resource) {
            result = ((Resource)notifier).getResourceSet();
        } else if (notifier instanceof CDOResourceNode) {
            CDOView view = ((CDOResourceNode)notifier).cdoView();
            if (view != null) {
                result = view.getResourceSet();
            }
        } else if (notifier instanceof EObject) {
            result = CDOUtils.getResourceSet((Notifier)((EObject)notifier).eResource());
        }
        return result;
    }

    public static boolean isCDOObject(EObject object) {
        ResourceSet resourceSet = CDOUtils.getResourceSet((Notifier)object);
        return resourceSet != null && CDOUtil.getViewSet((Notifier)resourceSet) != null;
    }

    public static CDOObject getCDOObject(EObject object) {
        CDOObject result = null;
        if (CDOUtils.isCDOObject(object)) {
            result = CDOUtil.getCDOObject((EObject)object);
        }
        return result;
    }

    public static CDOView getView(ResourceSet resourceSet) {
        CDOView[] views;
        CDOView result = null;
        CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)resourceSet);
        if (viewSet != null && (views = viewSet.getViews()).length > 0) {
            result = views[0];
        }
        return result;
    }

    public static boolean isLockable(CDOObject object) {
        return object.cdoLockState() != null;
    }

    public static boolean isLocked(CDOObject object, boolean remotely) {
        CDOLock lock;
        CDOLock cDOLock = lock = CDOUtils.isLockable(object) ? object.cdoWriteLock() : null;
        return lock != null && (remotely ? lock.isLockedByOthers() : lock.isLocked());
    }

    public static void lock(CDOObject object) {
        object.cdoWriteLock().lock();
    }

    public static void unlock(CDOObject object) {
        object.cdoWriteLock().unlock();
    }

    public static DawnState computeState(EObject object) {
        DawnState result = DawnState.CLEAN;
        CDOObject cdo = CDOUtils.getCDOObject(object);
        if (cdo != null) {
            if (cdo.cdoConflict()) {
                result = DawnState.CONFLICT;
            } else if (CDOUtils.isLocked(cdo, true)) {
                result = DawnState.LOCKED_REMOTELY;
            } else if (CDOUtils.isLocked(cdo, false)) {
                result = DawnState.LOCKED_LOCALLY;
            }
        }
        return result;
    }

    public static boolean isReadOnly(CDOObject object) {
        boolean result = CDOUtils.isLocked(object, true);
        if (!result) {
            CDORevision revision = object.cdoRevision();
            result = revision != null && !revision.getPermission().isWritable();
        }
        return result;
    }

    public static Iterable<EObject> getEObjects(Iterable<? extends CDOObject> cdoObjects) {
        return Iterables.transform(cdoObjects, CDOFunctions.getEObject());
    }

    public static void notify(Runnable broadcastCommand) {
        broadcastExecutor.execute(broadcastCommand);
    }

    public static void notify(final TransactionalEditingDomain domain, final Runnable broadcastCommand) {
        broadcastExecutor.execute(new Runnable(){

            public void run() {
                try {
                    domain.runExclusive(broadcastCommand);
                }
                catch (Exception e) {
                    Activator.log.error("Exception in execution of notification broadcast.", (Throwable)e);
                }
            }
        });
    }

    public static void setBroadcastExecutor(Executor executor) {
        broadcastExecutor = executor == null ? new DirectExecutor() : executor;
    }

    private static final class DirectExecutor
    implements Executor {
        private DirectExecutor() {
        }

        public void execute(Runnable command) {
            command.run();
        }
    }
}

