/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistryPopulator;
import org.eclipse.emf.cdo.common.util.NotAuthenticatedException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.spi.cdo.CDOMergingConflictResolver;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.security.ICredentialsProvider2;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider2;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryListener;
import org.eclipse.papyrus.cdo.core.IResourceSetDisposalApprover;
import org.eclipse.papyrus.cdo.core.PapyrusRepositoryEvent;
import org.eclipse.papyrus.cdo.core.resource.CDOAwareModelSet;
import org.eclipse.papyrus.cdo.core.resource.PapyrusCDOResourceFactory;
import org.eclipse.papyrus.cdo.internal.core.Activator;
import org.eclipse.papyrus.cdo.internal.core.CompositeResourceSetDisposalApprover;
import org.eclipse.papyrus.cdo.internal.core.GMFSafePackageProcessor;
import org.eclipse.papyrus.cdo.internal.core.ICredentialsProviderFactory;
import org.eclipse.papyrus.cdo.internal.core.IInteractiveCredentialsProvider;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.core.repositories.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusRepository
extends Container<CDOResourceNode>
implements IInternalPapyrusRepository,
IAdaptable {
    private static final String SECURE_STORE_PATH = "/org.eclipse.papyrus.cdo.core/repositories";
    private static final CDOResourceNode[] NO_RESOURCE_NODES = new CDOResourceNode[0];
    private final IManagedContainer container;
    private final Repository model;
    private CDOSession session;
    private final BiMap<ResourceSet, CDOView> readOnlyViews = HashBiMap.create();
    private final BiMap<ResourceSet, CDOTransaction> transactions = HashBiMap.create();
    private IListener viewListener;
    private CDOView masterView;
    private volatile CDOResourceNode[] topResourceNodes;
    private IListener masterViewListener;
    private final CompositeResourceSetDisposalApprover approvers = new CompositeResourceSetDisposalApprover();
    private final CopyOnWriteArrayList<IPapyrusRepositoryListener> listeners = new CopyOnWriteArrayList();

    public PapyrusRepository(IManagedContainer container, Repository model) {
        this.container = container;
        this.model = model;
        this.activate();
    }

    @Override
    public String getName() {
        return this.model.getName();
    }

    @Override
    public void setName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("null or empty name");
        }
        this.model.setName(name);
    }

    @Override
    public String getURL() {
        return this.model.getURL();
    }

    @Override
    public String getUsername() {
        return this.getSecureStorageValue("username");
    }

    @Override
    public void setUsername(String username) {
        if (username != null && (username = username.trim()).length() == 0) {
            username = null;
        }
        this.setSecureStorageValue("username", username, false);
    }

    @Override
    public String getPassword() {
        return this.getSecureStorageValue("password");
    }

    private String getSecureStorageValue(String key) {
        String path;
        String result = null;
        ISecurePreferences store = SecurePreferencesFactory.getDefault();
        if (store.nodeExists(path = this.getSecureStorePath())) {
            store = store.node(path);
            try {
                result = store.get(key, null);
            }
            catch (StorageException e) {
                Activator.log.error(String.format("Failed to load repository %s from secure storage.", key), (Throwable)e);
            }
        }
        return result;
    }

    private String getSecureStorePath() {
        return String.format("%s/%s", SECURE_STORE_PATH, EncodingUtils.encodeSlashes((String)this.getURL()));
    }

    @Override
    public void setPassword(String password) {
        this.setSecureStorageValue("password", password, true);
    }

    private void setSecureStorageValue(String key, String value, boolean encrypt) {
        ISecurePreferences store = SecurePreferencesFactory.getDefault().node(this.getSecureStorePath());
        try {
            if (value == null) {
                store.remove(key);
            } else {
                store.put(key, value, encrypt);
            }
        }
        catch (StorageException e) {
            Activator.log.error(String.format("Failed to store repository %s in secure storage.", key), (Throwable)e);
        }
    }

    @Override
    public void clearCredentials() {
        String path;
        ISecurePreferences store = SecurePreferencesFactory.getDefault();
        if (store.nodeExists(path = this.getSecureStorePath())) {
            store.node(path).removeNode();
        }
    }

    @Override
    public boolean isConnected() {
        return this.session != null && !this.session.isClosed();
    }

    @Override
    public void connect() {
        if (!this.isConnected()) {
            ICredentialsProvider2 creds = this.getCredentialsProvider();
            Object oldCreds = null;
            if (creds != null) {
                oldCreds = this.container.putElement("org.eclipse.net4j.util.security.credentialsProviders", "interactive", null, (Object)creds);
            }
            try {
                while (true) {
                    try {
                        this.session = (CDOSession)this.container.getElement("org.eclipse.emf.cdo.sessions", "cdo", this.getURL());
                    }
                    catch (NotAuthenticatedException e) {
                    }
                    catch (SecurityException e) {
                        this.clearCredentials();
                        if (!(creds instanceof IInteractiveCredentialsProvider)) continue;
                        ((IInteractiveCredentialsProvider)creds).reportCredentialsFailure(e);
                        continue;
                    }
                    break;
                }
                if (this.session != null) {
                    this.configure(this.session);
                    this.createReadOnlyView((ResourceSet)new ResourceSetImpl());
                    this.fireRepositoryEvent(0);
                }
            }
            finally {
                if (creds != null) {
                    if (oldCreds != null) {
                        this.container.putElement("org.eclipse.net4j.util.security.credentialsProviders", "interactive", null, oldCreds);
                    } else {
                        this.container.removeElement("org.eclipse.net4j.util.security.credentialsProviders", "interactive", null);
                    }
                }
            }
        }
    }

    private ICredentialsProvider2 getCredentialsProvider() {
        IPasswordCredentialsProvider2 result = null;
        ICredentialsProviderFactory factory = PapyrusRepositoryManager.INSTANCE.getCredentialsProviderFactory();
        if (factory != null) {
            result = factory.createCredentialsProvider(this);
        }
        return result;
    }

    @Override
    public void disconnect() throws org.eclipse.papyrus.cdo.core.CommitException {
        if (this.isConnected()) {
            ImmutableList dirty = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.transactions.keySet(), (Predicate)new Predicate<ResourceSet>(){

                public boolean apply(ResourceSet input) {
                    return ((CDOTransaction)PapyrusRepository.this.transactions.get((Object)input)).isDirty();
                }
            }));
            switch (this.approvers.disposalRequested(this, (Collection<ResourceSet>)dirty)) {
                case SAVE: {
                    for (ResourceSet next : dirty) {
                        this.commit(next);
                    }
                }
                case CLOSE: {
                    for (ResourceSet next : ImmutableList.copyOf((Collection)this.transactions.values())) {
                        this.doClose((CDOView)next);
                    }
                    for (ResourceSet next : ImmutableList.copyOf((Collection)this.readOnlyViews.values())) {
                        this.doClose((CDOView)next);
                    }
                    this.session.close();
                    this.session = null;
                    this.fireRepositoryEvent(1);
                    break;
                }
            }
        }
    }

    protected void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("not connected");
        }
    }

    @Override
    public Collection<ResourceSet> getReadOnlyViews() {
        return Collections.unmodifiableCollection(this.readOnlyViews.keySet());
    }

    @Override
    public ResourceSet createReadOnlyView(ResourceSet resourceSet) {
        this.checkConnected();
        CDOView view = this.session.openView(resourceSet);
        this.configure(view);
        ResourceSet result = view.getResourceSet();
        this.readOnlyViews.put((Object)result, (Object)view);
        if (this.masterView == null) {
            this.masterView = view;
            this.topResourceNodes = this.getElements();
            this.adaptMasterView(view);
            if (this.topResourceNodes.length > 0) {
                this.fireElementsAddedEvent(this.topResourceNodes);
            } else {
                this.fireEvent();
            }
        }
        return result;
    }

    @Override
    public Collection<ResourceSet> getTransactions() {
        return Collections.unmodifiableCollection(this.transactions.keySet());
    }

    @Override
    public ResourceSet createTransaction(ResourceSet resourceSet) {
        this.checkConnected();
        CDOTransaction transaction = this.session.openTransaction(resourceSet);
        this.configure(transaction);
        ResourceSet result = transaction.getResourceSet();
        this.transactions.put((Object)result, (Object)transaction);
        return result;
    }

    @Override
    public CDOSession getCDOSession() {
        return this.session;
    }

    @Override
    public CDOView getMasterView() {
        return this.masterView;
    }

    @Override
    public CDOView getCDOView(ResourceSet resourceSet) {
        CDOView result = (CDOView)this.readOnlyViews.get((Object)resourceSet);
        if (result == null) {
            result = (CDOView)this.transactions.get((Object)resourceSet);
        }
        return result;
    }

    protected void removeCDOView(ResourceSet resourceSet) {
        this.readOnlyViews.remove((Object)resourceSet);
        this.transactions.remove((Object)resourceSet);
    }

    CDOTransaction checkTransaction(CDOView view) {
        if (!(view instanceof CDOTransaction)) {
            throw new IllegalArgumentException("not a transaction");
        }
        return (CDOTransaction)view;
    }

    @Override
    public void commit(ResourceSet transaction) throws org.eclipse.papyrus.cdo.core.CommitException {
        CDOView cdoView = this.getCDOView(transaction);
        try {
            this.checkTransaction(cdoView).commit();
        }
        catch (CommitException e) {
            throw new org.eclipse.papyrus.cdo.core.CommitException(e);
        }
    }

    @Override
    public void rollback(ResourceSet transaction) {
        CDOView cdoView = this.getCDOView(transaction);
        this.checkTransaction(cdoView).rollback();
    }

    @Override
    public void close(ResourceSet view) {
        CDOView cdoView = this.getCDOView(view);
        if (cdoView != null) {
            this.doClose(cdoView);
        }
    }

    protected void doClose(CDOView view) {
        try {
            if (view == this.masterView) {
                this.unadaptMasterView(view);
                this.masterView = null;
                Object[] removedNodes = this.topResourceNodes;
                this.topResourceNodes = null;
                if (removedNodes != null && removedNodes.length > 0) {
                    this.fireElementsRemovedEvent(removedNodes);
                } else {
                    this.fireEvent();
                }
            }
        }
        finally {
            this.unadaptView(view);
            this.removeCDOView(view.getResourceSet());
            view.close();
        }
    }

    public Repository getModel() {
        return this.model;
    }

    protected void configure(CDOSession newSession) {
        CDOPackageRegistry registry = newSession.getPackageRegistry();
        CDOPackageRegistryPopulator.populate((CDOPackageRegistry)registry);
        if (registry instanceof InternalCDOPackageRegistry) {
            InternalCDOPackageRegistry internalRegistry = (InternalCDOPackageRegistry)registry;
            internalRegistry.setPackageProcessor((InternalCDOPackageRegistry.PackageProcessor)new GMFSafePackageProcessor(internalRegistry.getPackageProcessor()));
        }
    }

    protected void configure(CDOView newReadOnlyView) {
        this.adaptView(newReadOnlyView);
        this.commonViewConfiguration(newReadOnlyView);
    }

    protected void commonViewConfiguration(CDOView newView) {
        ResourceSet rset = newView.getResourceSet();
        if (rset instanceof CDOAwareModelSet) {
            rset.getResourceFactoryRegistry().getProtocolToFactoryMap().put("cdo", new PapyrusCDOResourceFactory((CDOAwareModelSet)rset));
        }
    }

    protected void configure(CDOTransaction newTransaction) {
        this.adaptView((CDOView)newTransaction);
        this.commonViewConfiguration((CDOView)newTransaction);
        newTransaction.options().addConflictResolver((CDOConflictResolver)new CDOMergingConflictResolver());
    }

    private IListener getViewListener() {
        if (this.viewListener == null) {
            this.viewListener = new LifecycleEventAdapter(){

                protected void onDeactivated(ILifecycle lifecycle) {
                    PapyrusRepository.this.readOnlyViews.inverse().remove((Object)lifecycle);
                    PapyrusRepository.this.transactions.inverse().remove((Object)lifecycle);
                }
            };
        }
        return this.viewListener;
    }

    private void adaptView(CDOView view) {
        view.addListener(this.getViewListener());
    }

    private void unadaptView(CDOView view) {
        view.removeListener(this.getViewListener());
    }

    private IListener getMasterViewListener() {
        if (this.masterViewListener == null) {
            this.masterViewListener = new IListener(){

                public void notifyEvent(IEvent event) {
                    if (event instanceof CDOViewInvalidationEvent) {
                        CDOViewInvalidationEvent inval = (CDOViewInvalidationEvent)event;
                        PapyrusRepository.this.translateMasterViewInvalidationEvent(inval);
                    }
                }
            };
        }
        return this.masterViewListener;
    }

    private void adaptMasterView(CDOView view) {
        view.addListener(this.getMasterViewListener());
    }

    private void unadaptMasterView(CDOView view) {
        view.removeListener(this.getMasterViewListener());
    }

    @Override
    public void addResourceSetDisposalApprover(IResourceSetDisposalApprover approver) {
        this.approvers.addApprover(approver);
    }

    @Override
    public void removeResourceSetDisposalApprover(IResourceSetDisposalApprover approver) {
        this.approvers.removeApprover(approver);
    }

    @Override
    public void addPapyrusRepositoryListener(IPapyrusRepositoryListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removePapyrusRepositoryListener(IPapyrusRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireRepositoryEvent(int eventType) {
        if (!this.listeners.isEmpty()) {
            PapyrusRepositoryEvent event = new PapyrusRepositoryEvent(this, eventType);
            for (IPapyrusRepositoryListener next : this.listeners) {
                try {
                    next.papyrusRepositoryChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in repository event listener.", (Throwable)e);
                }
            }
        }
    }

    public boolean isEmpty() {
        return !this.isActive() || !this.isConnected() || this.masterView == null || this.masterView.isEmpty();
    }

    public CDOResourceNode[] getElements() {
        CDOResourceNode[] result = NO_RESOURCE_NODES;
        if (this.masterView != null) {
            if (this.topResourceNodes == null) {
                this.topResourceNodes = (CDOResourceNode[])this.masterView.getElements();
            }
            result = this.topResourceNodes;
        }
        return result;
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        this.model.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                PapyrusRepository.this.fireEvent();
            }

            public boolean isAdapterForType(Object type) {
                return type == PapyrusRepository.class;
            }
        });
    }

    protected void doBeforeDeactivate() throws Exception {
        Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)this.model, PapyrusRepository.class);
        if (adapter != null) {
            this.model.eAdapters().remove((Object)adapter);
        }
        super.doBeforeDeactivate();
    }

    private void translateMasterViewInvalidationEvent(CDOViewInvalidationEvent event) {
        for (Map.Entry next : event.getRevisionDeltas().entrySet()) {
            CDOResourceNode resNode;
            if (!(next.getKey() instanceof CDOResourceNode) || !(resNode = (CDOResourceNode)next.getKey()).isRoot()) continue;
            LinkedHashSet currentNodes = Sets.newLinkedHashSet(Arrays.asList(this.getElements()));
            LinkedHashSet newNodes = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)((CDOResource)resNode).getContents(), CDOResourceNode.class));
            Sets.SetView removed = Sets.difference((Set)currentNodes, (Set)newNodes);
            Sets.SetView added = Sets.difference((Set)newNodes, (Set)currentNodes);
            ContainerEvent cEvent = new ContainerEvent((IContainer)this);
            for (CDOResourceNode r : removed) {
                cEvent.addDelta((Object)r, IContainerDelta.Kind.REMOVED);
            }
            for (CDOResourceNode a : added) {
                cEvent.addDelta((Object)a, IContainerDelta.Kind.ADDED);
            }
            this.topResourceNodes = (CDOResourceNode[])resNode.cdoView().getElements();
            this.fireEvent((IEvent)cEvent);
            break;
        }
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

