/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.Activator;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.core.ICredentialsProviderFactory;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.core.IRepositoryModelStorage;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.repositories.RepositoriesFactory;
import org.eclipse.papyrus.cdo.internal.core.repositories.RepositoriesPackage;
import org.eclipse.papyrus.cdo.internal.core.repositories.Repository;
import org.eclipse.papyrus.cdo.internal.core.repositories.RepositoryRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusRepositoryManager
extends Container<IPapyrusRepository>
implements IInternalPapyrusRepositoryManager {
    public static final PapyrusRepositoryManager INSTANCE = new PapyrusRepositoryManager();
    private final IRepositoryModelStorage storage;
    private final IManagedContainer container;
    private final RepositoryRegistry repositoryRegistry;
    private final Map<String, IInternalPapyrusRepository> repositories;
    private ICredentialsProviderFactory credentialsProviderFactory;

    public PapyrusRepositoryManager() {
        this(null);
    }

    public PapyrusRepositoryManager(IRepositoryModelStorage storage) {
        this.storage = storage;
        this.container = PapyrusRepositoryManager.createContainer();
        this.repositoryRegistry = this.loadRepositories();
        this.repositories = this.initializeRepositories();
        this.activate();
    }

    public void dispose() {
        this.deactivate();
    }

    private static IManagedContainer createContainer() {
        IManagedContainer result = ContainerUtil.createPluginContainer();
        result.activate();
        return result;
    }

    @Override
    public IManagedContainer getSessionsContainer() {
        return this.container;
    }

    @Override
    public Collection<? extends IPapyrusRepository> getRepositories() {
        return Collections.unmodifiableCollection(this.repositories.values());
    }

    @Override
    public IPapyrusRepository createRepository(String url) {
        if (this.getRepository(url) != null) {
            throw new IllegalArgumentException("repository already exists");
        }
        Repository repository = RepositoriesFactory.eINSTANCE.createRepository();
        repository.setURL(url);
        this.repositoryRegistry.getRepositories().add((Object)repository);
        PapyrusRepository result = new PapyrusRepository(this.container, repository);
        this.repositories.put(url, result);
        this.fireElementAddedEvent(result);
        return result;
    }

    @Override
    public void setURL(IPapyrusRepository repository, String url) {
        if (!Objects.equal((Object)repository.getURL(), (Object)url)) {
            if (this.getRepository(url) != null) {
                throw new IllegalArgumentException("repository already exists");
            }
            if (repository.isConnected()) {
                throw new IllegalStateException("repository is connected");
            }
            PapyrusRepository internalRepository = (PapyrusRepository)repository;
            this.repositories.remove(internalRepository.getURL());
            internalRepository.getModel().setURL(url);
            this.repositories.put(url, internalRepository);
        }
    }

    @Override
    public void removeRepository(IPapyrusRepository repository) {
        if (repository.isConnected()) {
            throw new IllegalArgumentException("repository is still connected");
        }
        this.repositories.remove(repository.getURL());
        EcoreUtil.delete((EObject)((PapyrusRepository)repository).getModel());
        this.fireElementRemovedEvent(repository);
    }

    @Override
    public IPapyrusRepository getRepository(String url) {
        return this.repositories.get(url);
    }

    @Override
    public IPapyrusRepository getRepositoryForURI(URI uri) {
        IInternalPapyrusRepository result = null;
        if (CDOUtils.isCDOURI(uri)) {
            String uuid = CDOURIUtil.extractRepositoryUUID((URI)uri);
            for (IInternalPapyrusRepository next : this.repositories.values()) {
                CDOSession session = next.getCDOSession();
                if (session == null || !Objects.equal((Object)uuid, (Object)session.getRepositoryInfo().getUUID())) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    @Override
    public void saveRepositories() {
        if (this.storage != null) {
            try {
                OutputStream output = this.storage.createOutputStream();
                try {
                    this.repositoryRegistry.eResource().save(output, null);
                }
                finally {
                    if (output != null) {
                        IOUtil.closeSilent((Closeable)output);
                    }
                }
            }
            catch (IOException e) {
                Activator.log.error("Failed to save model repositories to custom storage.", (Throwable)e);
            }
        } else {
            try {
                this.repositoryRegistry.eResource().save(null);
            }
            catch (IOException e) {
                Activator.log.error("Failed to save model repositories.", (Throwable)e);
            }
        }
        try {
            SecurePreferencesFactory.getDefault().flush();
        }
        catch (IOException e) {
            Activator.log.error("Failed to save repository passwords to secure storage.", (Throwable)e);
        }
    }

    private RepositoryRegistry loadRepositories() {
        RepositoryRegistry result;
        Resource resource;
        block12: {
            ResourceSetImpl rset = new ResourceSetImpl();
            rset.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
            File repositoriesFile = new File(Activator.getDefault().getStateLocation().toFile(), "repositories.xml");
            URI uri = URI.createFileURI((String)repositoriesFile.getAbsolutePath());
            resource = rset.createResource(uri);
            if (this.storage != null) {
                try {
                    InputStream input = this.storage.createInputStream();
                    if (input == null) break block12;
                    try {
                        resource.load(input, null);
                    }
                    finally {
                        IOUtil.closeSilent((Closeable)input);
                    }
                }
                catch (Exception e) {
                    Activator.log.error("Failed to load repository registry from custom storage.", (Throwable)e);
                }
            } else if (repositoriesFile.exists()) {
                try {
                    resource.load(null);
                }
                catch (Exception e) {
                    Activator.log.error("Failed to load repository registry.", (Throwable)e);
                    resource.getContents().clear();
                }
            } else {
                resource = rset.createResource(uri);
            }
        }
        if ((result = (RepositoryRegistry)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)RepositoriesPackage.Literals.REPOSITORY_REGISTRY)) == null) {
            result = RepositoriesFactory.eINSTANCE.createRepositoryRegistry();
            resource.getContents().add((Object)result);
        }
        return result;
    }

    private Map<String, IInternalPapyrusRepository> initializeRepositories() {
        HashMap result = Maps.newHashMap();
        for (Repository next : this.repositoryRegistry.getRepositories()) {
            result.put(next.getURL(), new PapyrusRepository(this.container, next));
        }
        return result;
    }

    @Override
    public ICredentialsProviderFactory getCredentialsProviderFactory() {
        return this.credentialsProviderFactory;
    }

    @Override
    public void setCredentialsProviderFactory(ICredentialsProviderFactory credentialsProviderFactory) {
        this.credentialsProviderFactory = credentialsProviderFactory;
    }

    @Override
    public IInternalPapyrusRepository getRepository(CDOView view) {
        IInternalPapyrusRepository result = null;
        int sessionID = view.getSessionID();
        for (IInternalPapyrusRepository next : this.repositories.values()) {
            if (!next.isConnected() || next.getCDOSession().getSessionID() != sessionID) continue;
            result = next;
            break;
        }
        return result;
    }

    public boolean isEmpty() {
        return !this.isActive() || this.repositories.isEmpty();
    }

    public IPapyrusRepository[] getElements() {
        return (IPapyrusRepository[])Iterables.toArray(this.repositories.values(), IPapyrusRepository.class);
    }
}

