/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.exporter;

import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.cdo.core.exporter.IModelExportMapping;
import org.eclipse.papyrus.cdo.core.exporter.IModelExporter;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferOperation;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.l10n.Messages;

public class ModelExporter
implements IModelExporter {
    public Diagnostic exportModels(final IModelExportMapping mapping) {
        BasicDiagnostic result = new BasicDiagnostic();
        ModelExporter.add((DiagnosticChain)result, mapping.getConfiguration().validate());
        ModelExporter.add((DiagnosticChain)result, mapping.validate());
        if (result.getSeverity() < 4) {
            ModelExporter.add((DiagnosticChain)result, mapping.getConfiguration().getOperationContext().run(new IModelTransferOperation(){

                public Diagnostic run(IProgressMonitor monitor) {
                    return ModelExporter.this.doExport(mapping, monitor);
                }
            }));
        }
        return result;
    }

    protected Diagnostic doExport(IModelExportMapping mapping, IProgressMonitor monitor) {
        BasicDiagnostic result = new BasicDiagnostic();
        IModelTransferConfiguration configuration = mapping.getConfiguration();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ModelExporter_0, (int)(configuration.getModelsToTransfer().size() + 2));
        IInternalPapyrusRepository repository = (IInternalPapyrusRepository)mapping.getRepository();
        ResourceSetImpl destination = new ResourceSetImpl();
        ResourceSet source = repository.createTransaction((ResourceSet)new ResourceSetImpl());
        CDOView view = repository.getCDOView(source);
        try {
            for (IModelTransferNode model : configuration.getModelsToTransfer()) {
                ModelExporter.add((DiagnosticChain)result, this.exportModel(model, view, mapping.getMapping(model), (ResourceSet)destination, (IProgressMonitor)sub.newChild(1)));
            }
            for (IModelTransferNode model : configuration.getModelsToTransfer()) {
                ModelExporter.add((DiagnosticChain)result, this.saveModel(model, view, mapping.getMapping(model), (ResourceSet)destination));
            }
            sub.worked(1);
        }
        finally {
            this.cleanUp((ResourceSet)destination);
            repository.close(source);
            this.cleanUp(source);
            sub.worked(1);
        }
        sub.done();
        return result;
    }

    protected Diagnostic exportModel(IModelTransferNode model, CDOView view, IPath toPath, ResourceSet rset, IProgressMonitor monitor) {
        BasicDiagnostic result = new BasicDiagnostic();
        IPath basePath = toPath.removeFileExtension();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)model.getName(), (int)model.getResourceURIs().size());
        for (URI next : model.getResourceURIs()) {
            Resource source = view.getResourceSet().getResource(next, true);
            Resource destination = rset.createResource(URI.createPlatformResourceURI((String)basePath.addFileExtension(next.fileExtension()).toString(), (boolean)true));
            ModelExporter.add((DiagnosticChain)result, this.exportResource(source, destination));
            sub.worked(1);
        }
        sub.done();
        return result;
    }

    protected Diagnostic exportResource(Resource source, Resource destination) {
        destination.getContents().addAll((Collection)source.getContents());
        return Diagnostic.OK_INSTANCE;
    }

    protected Diagnostic saveModel(IModelTransferNode model, CDOView view, IPath toPath, ResourceSet rset) {
        BasicDiagnostic result = new BasicDiagnostic();
        IPath basePath = toPath.removeFileExtension();
        for (URI next : model.getResourceURIs()) {
            Resource destination = rset.getResource(URI.createPlatformResourceURI((String)basePath.addFileExtension(next.fileExtension()).toString(), (boolean)true), false);
            try {
                destination.save(null);
            }
            catch (Exception e) {
                ModelExporter.add((DiagnosticChain)result, (Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, Messages.ModelExporter_1, new Object[]{e}));
            }
        }
        return result;
    }

    private void cleanUp(ResourceSet resourceSet) {
        for (Resource next : resourceSet.getResources()) {
            next.unload();
            next.eAdapters().clear();
        }
        resourceSet.getResources().clear();
    }

    private static void add(DiagnosticChain diagnostics, Diagnostic diagnostic) {
        if (diagnostic.getSeverity() > 0) {
            diagnostics.merge(diagnostic);
        }
    }
}

