/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.importer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyAdapter
extends AdapterImpl {
    private final Set<Resource> dependencies = Sets.newLinkedHashSet();
    private final Set<Resource> dependents = Sets.newLinkedHashSet();

    private DependencyAdapter() {
    }

    public static DependencyAdapter getInstance(Resource resource) {
        DependencyAdapter result = DependencyAdapter.getExistingInstance(resource);
        if (result == null) {
            result = new DependencyAdapter();
            resource.eAdapters().add(Math.min(1, resource.eAdapters().size()), (Object)result);
            result.analyze(resource);
        }
        return result;
    }

    static DependencyAdapter getExistingInstance(Resource resource) {
        DependencyAdapter result = null;
        for (Object next : resource.eAdapters()) {
            if (!(next instanceof DependencyAdapter)) continue;
            result = (DependencyAdapter)((Object)next);
            break;
        }
        return result;
    }

    public Set<Resource> getDependencies() {
        return this.dependencies;
    }

    public static Set<Resource> getDependencies(Resource resource) {
        return DependencyAdapter.getInstance(resource).getDependencies();
    }

    public Set<Resource> getDependents() {
        return this.dependents;
    }

    public static Set<Resource> getDependents(Resource resource) {
        return DependencyAdapter.getInstance(resource).getDependents();
    }

    private void analyze(Resource resource) {
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            for (EObject xref : ((EObject)iter.next()).eCrossReferences()) {
                Resource xrefRes = xref.eResource();
                if (xrefRes == null || !this.isUserModelResource(xrefRes.getURI())) continue;
                this.addDependency(xrefRes);
            }
        }
        if (DependencyAdapter.isDIResource(resource)) {
            int size;
            int oldSize = 0;
            do {
                size = this.dependencies.size();
                for (Resource firstOrder : ImmutableList.copyOf(this.dependencies).subList(oldSize, size)) {
                    for (Resource next : DependencyAdapter.getDependencies(firstOrder)) {
                        if (DependencyAdapter.getDIResource(next) != resource) continue;
                        this.addDependency(next);
                    }
                }
            } while ((oldSize = size) < this.dependencies.size());
        }
    }

    private Resource getResource() {
        return (Resource)this.getTarget();
    }

    private void addDependency(Resource resource) {
        Resource self = this.getResource();
        if (resource != self && this.dependencies.add(resource)) {
            DependencyAdapter.getInstance(resource).addDependent(self);
        }
    }

    private void addDependent(Resource resource) {
        if (resource != this.getResource()) {
            this.dependents.add(resource);
        }
    }

    boolean isUserModelResource(URI uri) {
        return (uri.isPlatformResource() || uri.isFile() || CDOUtils.isCDOURI(uri)) && !uri.isArchive();
    }

    public static boolean isDIResource(Resource resource) {
        boolean result = false;
        for (EObject next : resource.getContents()) {
            if (!(next instanceof SashWindowsMngr)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Resource getDIResource(Resource resource) {
        Resource result = null;
        if (DependencyAdapter.isDIResource(resource)) {
            result = resource;
        } else {
            Resource di;
            ResourceSet rset = resource.getResourceSet();
            URI uri = resource.getURI().trimFileExtension().appendFileExtension("di");
            if (rset.getURIConverter().exists(uri, null) && (di = rset.getResource(uri, true)) != null && DependencyAdapter.isDIResource(di)) {
                result = di;
            }
        }
        return result;
    }
}

