/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.importer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.importer.IModelDependentsProvider;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferListener;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferOperation;
import org.eclipse.papyrus.cdo.internal.core.Activator;
import org.eclipse.papyrus.cdo.internal.core.importer.DependencyAdapter;
import org.eclipse.papyrus.cdo.internal.core.importer.ModelTransferNode;
import org.eclipse.papyrus.cdo.internal.core.importer.ReentrantOperationContext;
import org.eclipse.papyrus.cdo.internal.core.l10n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelTransferConfiguration
implements IModelTransferConfiguration {
    private final Direction direction;
    private Map<URI, Resource> resources = Maps.newHashMap();
    private ResourceSet resourceSet;
    private final boolean ownResourceSet;
    private final IModelTransferOperation.Context operationContext;
    private final Map<Resource, IModelTransferNode> importNodes = Maps.newHashMap();
    private final Set<IModelTransferNode> modelsToImport = Sets.newHashSet();
    private final Collection<IModelDependentsProvider> dependentsProviders = Lists.newArrayList();
    private final CopyOnWriteArrayList<IModelTransferListener> listeners = new CopyOnWriteArrayList();

    public ModelTransferConfiguration(IModelTransferOperation.Context operationContext, ResourceSet resourceSet) {
        this(operationContext, resourceSet, Direction.IMPORT);
    }

    public ModelTransferConfiguration(IModelTransferOperation.Context operationContext, ResourceSet resourceSet, Direction direction) {
        this.direction = direction;
        this.operationContext = new ReentrantOperationContext(operationContext);
        if (resourceSet != null) {
            this.resourceSet = resourceSet;
            this.ownResourceSet = false;
        } else {
            this.resourceSet = new ResourceSetImpl();
            ((ResourceSetImpl)this.resourceSet).setURIResourceMap(this.resources);
            this.ownResourceSet = true;
        }
    }

    public final Direction getDirection() {
        return this.direction;
    }

    @Override
    public void dispose() {
        if (this.resourceSet != null) {
            if (this.ownResourceSet) {
                for (Resource next : this.resourceSet.getResources()) {
                    next.unload();
                    next.eAdapters().clear();
                }
                this.resourceSet.getResources().clear();
                this.resourceSet.eAdapters().clear();
                this.resourceSet = null;
            } else {
                for (Resource next : this.resourceSet.getResources()) {
                    DependencyAdapter adapter = DependencyAdapter.getExistingInstance(next);
                    next.eAdapters().remove((Object)adapter);
                }
            }
            this.resources.clear();
            this.resources = null;
        }
        this.listeners.clear();
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public IModelTransferOperation.Context getOperationContext() {
        return this.operationContext;
    }

    @Override
    public Collection<IModelTransferNode> getModelsToTransfer() {
        return Collections.unmodifiableSet(this.modelsToImport);
    }

    @Override
    public IModelTransferNode addModelToTransfer(URI resourceURI) {
        IModelTransferNode result = this.getNode(resourceURI);
        if (this.modelsToImport.add(result)) {
            this.fireModelsToImportChanged();
        }
        return result;
    }

    protected IModelTransferNode getNode(URI resourceURI) {
        IModelTransferNode result = null;
        Resource resource = this.resourceSet.getResource(resourceURI, true);
        if (resource != null && (result = this.importNodes.get(resource)) == null) {
            final ModelTransferNode newNode = new ModelTransferNode(this, resource);
            this.importNodes.put(resource, newNode);
            newNode.initialize(this.getOperationContext());
            Diagnostic problems = this.getOperationContext().run(new IModelTransferOperation(){

                public Diagnostic run(IProgressMonitor monitor) {
                    SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ModelTransferConfiguration_0, (int)ModelTransferConfiguration.this.dependentsProviders.size());
                    for (IModelDependentsProvider next : ModelTransferConfiguration.this.dependentsProviders) {
                        for (URI uri : next.getDependents(newNode.getPrimaryResource(), monitor)) {
                            newNode.addDependent(ModelTransferConfiguration.this.getNode(uri));
                        }
                        sub.worked(1);
                    }
                    sub.done();
                    return Diagnostic.OK_INSTANCE;
                }
            });
            this.fireModelDependentsChanged(newNode);
            this.fireProblemsEvent(problems);
            result = newNode;
        }
        return result;
    }

    @Override
    public void removeModelToTransfer(IModelTransferNode node) {
        if (this.modelsToImport.remove(node)) {
            this.fireModelsToImportChanged();
        }
    }

    @Override
    public void addModelDependentsProvider(IModelDependentsProvider provider) {
        if (!this.dependentsProviders.contains(provider)) {
            this.dependentsProviders.add(provider);
        }
    }

    @Override
    public Diagnostic validate() {
        BasicDiagnostic result = new BasicDiagnostic();
        ImmutableSet toImport = ImmutableSet.copyOf(this.getModelsToTransfer());
        for (IModelTransferNode node : toImport) {
            this.checkDependents(node, (Set<IModelTransferNode>)toImport, (DiagnosticChain)result);
            this.checkDependencies(node, (Set<IModelTransferNode>)toImport, (DiagnosticChain)result);
        }
        this.fireProblemsEvent((Diagnostic)result);
        return result;
    }

    protected void checkDependents(IModelTransferNode node, Set<IModelTransferNode> toImport, DiagnosticChain diagnostics) {
        ImmutableSet dependents = ImmutableSet.copyOf(node.getDependents());
        Sets.SetView leftOut = Sets.difference((Set)dependents, toImport);
        if (!leftOut.isEmpty()) {
            int severity = this.direction.isImport() ? 2 : 1;
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.papyrus.cdo.core", 0, NLS.bind((String)Messages.ModelTransferConfiguration_1, (Object)node.getName(), (Object)((Object)this.direction)), new Object[]{node, leftOut}));
        }
    }

    protected void checkDependencies(IModelTransferNode node, Set<IModelTransferNode> toImport, DiagnosticChain diagnostics) {
        ImmutableSet dependencies = ImmutableSet.copyOf(node.getDependencies());
        Sets.SetView leftOut = Sets.difference((Set)dependencies, toImport);
        if (!leftOut.isEmpty()) {
            int severity = this.direction.isImport() ? 1 : 2;
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.papyrus.cdo.core", 0, NLS.bind((String)Messages.ModelTransferConfiguration_2, (Object)node.getName(), (Object)((Object)this.direction)), new Object[]{node, leftOut}));
        }
    }

    @Override
    public void addModelTransferListener(IModelTransferListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeModelTransferListener(IModelTransferListener listener) {
        this.listeners.remove(listener);
    }

    void fireProblemsEvent(Diagnostic problems) {
        if (problems.getSeverity() > 0) {
            for (IModelTransferListener next : this.listeners) {
                try {
                    next.modelTransferProblemsOccurred(problems);
                }
                catch (Exception e) {
                    Activator.log.error(NLS.bind((String)"Uncaught exception in model {0} listener.", (Object)this.direction.name()), (Throwable)e);
                }
            }
        }
    }

    void fireModelsToImportChanged() {
        for (IModelTransferListener next : this.listeners) {
            try {
                next.modelsToTransferChanged(this);
            }
            catch (Exception e) {
                Activator.log.error(NLS.bind((String)"Uncaught exception in model {0} listener.", (Object)this.direction.name()), (Throwable)e);
            }
        }
    }

    void fireModelDependentsChanged(IModelTransferNode node) {
        for (IModelTransferListener next : this.listeners) {
            try {
                next.modelDependentsChanged(node);
            }
            catch (Exception e) {
                Activator.log.error(NLS.bind((String)"Uncaught exception in model {0} listener.", (Object)this.direction.name()), (Throwable)e);
            }
        }
    }

    boolean hasResource(URI uri) {
        return this.resources.containsKey(uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        IMPORT(Messages.ModelTransferConfiguration_6),
        EXPORT(Messages.ModelTransferConfiguration_7);

        private final String label;

        private Direction(String label) {
            this.label = label;
        }

        public boolean isImport() {
            return this == IMPORT;
        }

        public String toString() {
            return this.label;
        }
    }
}

