/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.core.RepositoryManagerEventAdapter;
import org.eclipse.papyrus.cdo.core.util.CDOFunctions;
import org.eclipse.papyrus.cdo.core.util.CDOPredicates;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage.CDOTextURIHandler;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.storage.AbstractContextStorageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOContextStorageProvider
extends AbstractContextStorageProvider {
    public static final String CONTEXTS_PATH = "org.eclipse.papyrus.cdo.ui.customization.properties.contexts";
    public static final String CONTEXT_EXTENSION = "ctx";
    private final IInternalPapyrusRepositoryManager repoMan = PapyrusRepositoryManager.INSTANCE;
    private ResourceSet resourceSet;
    private CDOTextURIHandler uriHandler;
    private RepositoryManagerEventAdapter repositoryAdapter;
    private final Multimap<IPapyrusRepository, Context> contexts = HashMultimap.create();

    public void initialize(ResourceSet resourceSet) throws CoreException {
        this.resourceSet = resourceSet;
        this.uriHandler = CDOTextURIHandler.install(resourceSet);
        resourceSet.getURIConverter().getURIHandlers().add((Object)this.uriHandler);
        this.repositoryAdapter = new RepositoryAdapter().install((IPapyrusRepositoryManager)this.repoMan);
    }

    public void dispose() {
        if (this.repositoryAdapter != null) {
            this.repositoryAdapter.uninstall((IPapyrusRepositoryManager)this.repoMan);
            this.repositoryAdapter = null;
            this.uriHandler.uninstall();
            this.uriHandler = null;
            this.resourceSet = null;
        }
        super.dispose();
    }

    public boolean providesFor(Context context) {
        URI uri = EcoreUtil.getURI((EObject)context);
        return uri != null && CDOUtils.isCDOURI((URI)uri) || "papyrus.cdo.text".equals(uri.scheme());
    }

    public Collection<? extends Context> loadContexts() throws CoreException {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(this.getRepositories(), this.getContexts())));
    }

    Iterable<? extends IInternalPapyrusRepository> getRepositories() {
        return Iterables.filter((Iterable)this.repoMan.getRepositories(), IInternalPapyrusRepository.class);
    }

    Function<IInternalPapyrusRepository, Iterable<? extends Context>> getContexts() {
        return new Function<IInternalPapyrusRepository, Iterable<? extends Context>>(){

            public Iterable<? extends Context> apply(IInternalPapyrusRepository input) {
                return CDOContextStorageProvider.this.getContexts(input);
            }
        };
    }

    Iterable<? extends Context> getContexts(IInternalPapyrusRepository repository) {
        Iterable<Object> result;
        if (!repository.isConnected()) {
            result = Collections.emptyList();
        } else {
            CDOResourceFolder folder = null;
            try {
                folder = repository.getMasterView().getResourceFolder(CONTEXTS_PATH);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (folder == null) {
                result = Collections.emptyList();
            } else {
                Iterable textNodes = Iterables.concat((Iterable)Iterables.transform((Iterable)folder.getNodes(), (Function)CDOFunctions.getFolderContents(CDOTextResource.class)));
                result = this.getContexts(textNodes);
                this.contexts.replaceValues((Object)repository, result);
            }
        }
        return result;
    }

    Iterable<? extends Context> getContexts(Iterable<CDOTextResource> textResources) {
        return Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.transform((Iterable)Iterables.filter(textResources, (Predicate)CDOPredicates.hasExtension((String)CONTEXT_EXTENSION)), this.getContextResource()), (Function)CDOFunctions.getRoot(Context.class)), (Predicate)Predicates.notNull());
    }

    private Function<CDOTextResource, Resource> getContextResource() {
        return new Function<CDOTextResource, Resource>(){

            public Resource apply(CDOTextResource input) {
                return CDOContextStorageProvider.this.resourceSet.getResource(CDOTextURIHandler.createURI(input.getURI()), true);
            }
        };
    }

    public void refreshContext(Context context) throws CoreException {
    }

    private class RepositoryAdapter
    extends RepositoryManagerEventAdapter {
        RepositoryAdapter() {
            super(CDOContextStorageProvider.this.resourceSet);
        }

        protected void onConnected(IPapyrusRepository repository) {
            if (repository instanceof IInternalPapyrusRepository) {
                repository.createReadOnlyView(CDOContextStorageProvider.this.resourceSet);
                ImmutableList added = ImmutableList.copyOf(CDOContextStorageProvider.this.getContexts((IInternalPapyrusRepository)repository));
                if (!added.isEmpty()) {
                    CDOContextStorageProvider.this.fireContextsAdded((Collection)added);
                }
            }
        }

        protected void onDisconnected(IPapyrusRepository repository) {
            ImmutableList removed = ImmutableList.copyOf((Collection)CDOContextStorageProvider.this.contexts.get((Object)repository));
            if (!removed.isEmpty()) {
                CDOContextStorageProvider.this.contexts.removeAll((Object)repository);
                CDOContextStorageProvider.this.fireContextsRemoved((Collection)removed);
            }
        }

        protected void onInvalidation(IPapyrusRepository repository, CDOView view, CDOViewInvalidationEvent event) {
            if (view.hasResource(CDOContextStorageProvider.CONTEXTS_PATH)) {
                CDOResourceFolder folder = view.getResourceFolder(CDOContextStorageProvider.CONTEXTS_PATH);
                URI prefix = folder.getURI();
                if (!prefix.isPrefix()) {
                    prefix = prefix.appendSegment("");
                }
                ArrayList contextResources = Lists.newArrayList();
                Iterable textResources = Iterables.filter((Iterable)Iterables.filter((Iterable)event.getDirtyObjects(), CDOTextResource.class), (Predicate)CDOPredicates.hasURIPrefix((URI)prefix));
                for (CDOTextResource next : textResources) {
                    URI relative = next.getURI().deresolve(prefix);
                    URI contextURI = prefix.appendSegment(relative.segment(0)).appendSegment(relative.segment(0)).appendFileExtension(CDOContextStorageProvider.CONTEXT_EXTENSION);
                    String path = CDOURIUtil.extractResourcePath((URI)contextURI);
                    if (!view.hasResource(path)) continue;
                    try {
                        contextResources.add(view.getTextResource(path));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ImmutableList changed = ImmutableList.copyOf(CDOContextStorageProvider.this.getContexts(contextResources));
                if (!changed.isEmpty()) {
                    CDOContextStorageProvider.this.fireContextsChanged((Collection)changed);
                }
            }
        }
    }
}

