/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.eclipse.emf.cdo.common.lob.CDOClob;

public class ClobInputStream
extends InputStream {
    private static final int BUFFER_SIZE_IN_CHARS = 2048;
    private static final int MASK = 255;
    private static final int EOF = -1;
    private final Charset charset;
    private Reader reader;
    private CharBuffer chars = CharBuffer.allocate(2048);
    private ByteBuffer buffer;

    public ClobInputStream(CDOClob clob, String encoding) throws IOException {
        this.reader = clob.getContents();
        this.charset = Charset.forName(encoding == null ? "UTF-8" : encoding);
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.buffer = null;
            this.chars = null;
        }
    }

    public int read() throws IOException {
        this.checkClosed();
        this.checkBuffer();
        if (this.buffer != null) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    private void checkBuffer() throws IOException {
        if (this.buffer == null || !this.buffer.hasRemaining()) {
            this.buffer = null;
            this.createBuffer();
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toRead;
        this.checkClosed();
        if (len == 0) {
            return 0;
        }
        this.checkBuffer();
        if (this.buffer == null) {
            return -1;
        }
        int count = 0;
        do {
            this.checkBuffer();
            if (this.buffer == null) break;
            toRead = Math.min(this.buffer.remaining(), len - count);
            this.buffer.get(b, off + count, toRead);
        } while ((count += toRead) < len);
        return count;
    }

    public int available() throws IOException {
        this.checkClosed();
        this.checkBuffer();
        if (this.buffer != null) {
            return this.buffer.remaining();
        }
        return 0;
    }

    protected final void checkClosed() throws IOException {
        if (this.reader == null) {
            throw new IOException("CLOB reader is closed");
        }
    }

    private void createBuffer() throws IOException {
        this.checkClosed();
        this.chars.rewind();
        int count = this.reader.read(this.chars);
        if (count > 0) {
            this.chars.flip();
            this.buffer = this.charset.encode(this.chars);
        }
    }
}

