/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage.action;

import com.google.common.base.Supplier;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.Activator;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.messages.Messages;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage.CDOTextURIHandler;
import org.eclipse.papyrus.cdo.internal.ui.customization.properties.storage.action.AbstractCDOContextAction;
import org.eclipse.papyrus.cdo.internal.ui.dialogs.RepositorySelectionDialog;
import org.eclipse.papyrus.customization.properties.storage.actions.ContextStorageActionUtil;
import org.eclipse.papyrus.customization.properties.storage.actions.IContextCopyAction;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.properties.catalog.PropertiesURIHandler;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.util.PropertiesUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CDOContextCopyAction
extends AbstractCDOContextAction
implements IContextCopyAction {
    public String getLabel() {
        return Messages.CDOContextCopyAction_0;
    }

    public String getToolTip() {
        return Messages.CDOContextCopyAction_1;
    }

    public Context copy(Context source, String targetName, IProgressMonitor monitor) throws CoreException {
        IInternalPapyrusRepository repository = this.selectRepository(source);
        if (repository == null) {
            return null;
        }
        CDOTransaction transaction = (CDOTransaction)repository.getCDOView(repository.createTransaction((ResourceSet)new ResourceSetImpl()));
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        Context result = null;
        try {
            try {
                CDOResourceFolder contextsFolder = transaction.getOrCreateResourceFolder("org.eclipse.papyrus.cdo.ui.customization.properties.contexts");
                String folderPath = new Path(contextsFolder.getPath()).append(targetName).toString();
                String resourcePath = new Path(folderPath).append(targetName).addFileExtension("ctx").toString();
                if (transaction.hasResource(folderPath)) {
                    throw new IOException(Messages.CDOContextCopyAction_2);
                }
                transaction.createResourceFolder(folderPath);
                CDOTextResource targetResource = transaction.createTextResource(resourcePath);
                URI targetModelURI = CDOTextURIHandler.createURI(targetResource.getURI());
                ResourceSet resourceSet = transaction.getResourceSet();
                CDOTextURIHandler.install(resourceSet);
                Context sourceContext = (Context)EMFHelper.loadEMFModel((ResourceSet)resourceSet, (URI)source.eResource().getURI());
                IStatus copyResult = this.copyAll(sourceContext, targetResource, (IProgressMonitor)sub);
                if (copyResult.isOK()) {
                    Context resultContext = (Context)EMFHelper.loadEMFModel((ResourceSet)resourceSet, (URI)targetModelURI);
                    resultContext.setName(targetName);
                    resultContext.setPrototype(sourceContext);
                    resultContext.eResource().save(null);
                    long commitTime = System.currentTimeMillis();
                    transaction.commit();
                    ResourceSet mainResourceSet = source.eResource().getResourceSet();
                    repository.getCDOView(mainResourceSet).waitForUpdate(commitTime, 30000L);
                    result = (Context)EMFHelper.loadEMFModel((ResourceSet)mainResourceSet, (URI)targetModelURI);
                } else if (copyResult.getSeverity() != 8) {
                    throw new CoreException(copyResult);
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.cdo.ui.customization.properties", e.getLocalizedMessage(), (Throwable)e));
            }
        }
        finally {
            transaction.close();
            sub.done();
        }
        return result;
    }

    protected IInternalPapyrusRepository selectRepository(Context context) {
        PapyrusRepositoryManager mgr = PapyrusRepositoryManager.INSTANCE;
        IPapyrusRepository result = null;
        IPapyrusRepository initialSelection = null;
        URI uri = context.eResource().getURI();
        if (CDOUtils.isCDOURI((URI)uri)) {
            initialSelection = mgr.getRepositoryForURI(uri);
        }
        if (initialSelection == null) {
            for (IPapyrusRepository next : mgr.getRepositories()) {
                if (!next.isConnected()) continue;
                initialSelection = next;
                break;
            }
        }
        result = initialSelection;
        if (mgr.getRepositories().size() > 1) {
            IPapyrusRepository[] innerResult = new IPapyrusRepository[]{initialSelection};
            Display.getDefault().syncExec(new Runnable((IPapyrusRepositoryManager)mgr, innerResult){
                private final /* synthetic */ IPapyrusRepositoryManager val$mgr;
                private final /* synthetic */ IPapyrusRepository[] val$innerResult;
                {
                    this.val$mgr = iPapyrusRepositoryManager;
                    this.val$innerResult = iPapyrusRepositoryArray;
                }

                public void run() {
                    Shell active = Display.getDefault().getActiveShell();
                    RepositorySelectionDialog dlg = new RepositorySelectionDialog(active, this.val$mgr, this.val$innerResult[0], (Supplier)new Supplier<IRunnableContext>(){

                        public IRunnableContext get() {
                            return new ProgressMonitorDialog(Display.getDefault().getActiveShell());
                        }
                    });
                    this.val$innerResult[0] = dlg.open() == 0 ? dlg.getSelectedRepository() : null;
                }
            });
            result = innerResult[0];
        }
        return (IInternalPapyrusRepository)result;
    }

    private IStatus copyAll(Context source, CDOTextResource target, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContextStorageActionUtil.initializeCopy((Context)source, (IProgressMonitor)sub.newChild(10));
        return this.doCopy(source, target, (IProgressMonitor)sub.newChild(90));
    }

    private IStatus doCopy(Context source, CDOTextResource target, IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        CDOResourceFolder targetFolder = target.getFolder();
        String targetName = target.getName();
        try {
            Resource sourceResource = source.eResource();
            int resourcesToCopy = sourceResource.getResourceSet().getResources().size();
            LinkedList<Context> contexts = new LinkedList<Context>();
            for (Context context : PropertiesUtil.getDependencies((Context)source)) {
                if (!ContextStorageActionUtil.isRelative((Resource)sourceResource, (Resource)context.eResource())) continue;
                contexts.add(context);
                for (Tab tab : context.getTabs()) {
                    resourcesToCopy += tab.getSections().size();
                }
            }
            monitor.beginTask(NLS.bind((String)Messages.CDOContextCopyAction_3, (Object)source.getName(), (Object)target.getName()), resourcesToCopy);
            this.copy(sourceResource.getResourceSet(), sourceResource.getURI(), target);
            monitor.worked(1);
            for (Resource resource : sourceResource.getResourceSet().getResources()) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (resource != sourceResource && ContextStorageActionUtil.isRelative((Resource)sourceResource, (Resource)resource)) {
                    this.copy(resource, targetFolder, sourceResource, targetName);
                }
                monitor.worked(1);
            }
            for (Context context : contexts) {
                for (Tab tab : context.getTabs()) {
                    for (Section section : tab.getSections()) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        this.copy(section.getSectionFile(), targetFolder, sourceResource);
                        monitor.worked(1);
                    }
                }
            }
            monitor.done();
        }
        catch (IOException ex) {
            Activator.log.error((Throwable)ex);
            result = new Status(4, "org.eclipse.papyrus.cdo.ui.customization.properties", "An error occurred during the copy of " + source.getName(), (Throwable)ex);
            monitor.done();
        }
        return result;
    }

    protected void copy(String xwtFileName, CDOResourceFolder targetFolder, Resource sourceResource) throws IOException {
        CDOTextResource target = ((CDOTransaction)targetFolder.cdoView()).createTextResource(new Path(targetFolder.getPath()).append(xwtFileName).toString());
        URI sourceURI = URI.createURI((String)xwtFileName).resolve(sourceResource.getURI());
        this.copy(sourceResource.getResourceSet(), sourceURI, target);
    }

    protected void copy(ResourceSet sourceResourceSet, URI sourceURI, CDOTextResource target) throws IOException {
        PropertiesURIHandler uriHandler = new PropertiesURIHandler();
        if (uriHandler.canHandle(sourceURI)) {
            sourceURI = uriHandler.getConvertedURI(sourceURI);
        }
        InputStream input = null;
        try {
            try {
                input = sourceResourceSet.getURIConverter().createInputStream(sourceURI);
                String encoding = input instanceof URIConverter.Readable ? ((URIConverter.Readable)input).getEncoding() : "UTF-8";
                InputStreamReader contents = new InputStreamReader(input, encoding);
                target.setContents(new CDOClob((Reader)contents));
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
                if (input != null) {
                    Closeables.closeQuietly((Closeable)input);
                }
            }
        }
        finally {
            if (input != null) {
                Closeables.closeQuietly((Closeable)input);
            }
        }
    }

    private void copy(Resource resource, CDOResourceFolder folder, Resource base, String targetName) throws IOException {
        URI relativeURI = resource.getURI().deresolve(base.getURI());
        if (relativeURI.toString().equals("")) {
            relativeURI = URI.createURI((String)(String.valueOf(targetName) + ".ctx"));
        }
        URI uri = relativeURI.resolve(folder.getURI().appendSegment("dummy.ctx"));
        CDOTextResource target = ((CDOTransaction)folder.cdoView()).createTextResource(CDOURIUtil.extractResourcePath((URI)uri));
        this.copy(resource.getResourceSet(), resource.getURI(), target);
    }
}

