/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.dataprovider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.widgets.providers.HierarchicToFlatContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class UMLSingleReferenceComboBoxDataProvider
implements IComboBoxDataProvider {
    private ITableAxisElementProvider elementProvider;
    private Object axisElement;

    public UMLSingleReferenceComboBoxDataProvider(Object axisElement, ITableAxisElementProvider elementProvider) {
        this.elementProvider = elementProvider;
        this.axisElement = axisElement;
    }

    public List<?> getValues(int columnIndex, int rowIndex) {
        Object colElement = this.elementProvider.getColumnElement(columnIndex);
        Object rowElement = this.elementProvider.getRowElement(rowIndex);
        colElement = AxisUtils.getRepresentedElement((Object)colElement);
        rowElement = AxisUtils.getRepresentedElement((Object)rowElement);
        Element editedElement = null;
        Object axis = null;
        if (colElement == this.axisElement && rowElement instanceof EObject) {
            editedElement = (Element)rowElement;
            axis = colElement;
        } else if (colElement instanceof EObject && rowElement == this.axisElement) {
            editedElement = (Element)colElement;
            axis = rowElement;
        }
        if (editedElement != null && axis != null) {
            if (axis instanceof EReference) {
                return this.getPossibleValues((EObject)editedElement, (EReference)axis);
            }
            String id = AxisUtils.getPropertyId((Object)this.axisElement);
            return this.getPossibleValuesForStereotypeProperty(editedElement, id);
        }
        return Collections.emptyList();
    }

    private List<EObject> getPossibleValues(EObject element, EReference feature) {
        ArrayList<EObject> availableValues = new ArrayList<EObject>();
        UMLContentProvider provider = new UMLContentProvider(element, (EStructuralFeature)feature, null, element.eResource().getResourceSet());
        HierarchicToFlatContentProvider flatP = new HierarchicToFlatContentProvider((IHierarchicContentProvider)provider);
        List<Object> list = Arrays.asList(flatP.getElements());
        for (Object current : list) {
            if (!(current instanceof EObject)) continue;
            availableValues.add((EObject)current);
        }
        return availableValues;
    }

    private List<EObject> getPossibleValuesForStereotypeProperty(Element element, String id) {
        ArrayList<EObject> availableValues = new ArrayList<EObject>();
        Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)element, id);
        List<Stereotype> stereotypes = UMLTableUtils.getAppliedSteretoypesWithThisProperty(element, id);
        EObject steAppl = element.getStereotypeApplication(stereotypes.get(0));
        EStructuralFeature stereotypePropertyFeature = steAppl.eClass().getEStructuralFeature(prop.getName());
        Stereotype ste = stereotypes.get(0);
        EObject container = prop.eContainer();
        assert (container instanceof Stereotype);
        UMLContentProvider provider = new UMLContentProvider(steAppl, stereotypePropertyFeature, ste, element.eResource().getResourceSet());
        HierarchicToFlatContentProvider flatP = new HierarchicToFlatContentProvider((IHierarchicContentProvider)provider);
        List<Object> list = Arrays.asList(flatP.getElements());
        for (Object current : list) {
            if (!(current instanceof EObject)) continue;
            availableValues.add((EObject)current);
        }
        return availableValues;
    }

    public EObject getEditedEObject(int columnIndex, int rowIndex) {
        Object colElement = this.elementProvider.getColumnElement(columnIndex);
        Object rowElement = this.elementProvider.getRowElement(rowIndex);
        Element el = (Element)rowElement;
        if (colElement == this.axisElement) {
            el = (Element)rowElement;
        } else if (rowElement == this.axisElement) {
            el = (Element)colElement;
        }
        return el;
    }

    public Object getEditedFeature(int columnIndex, int rowIndex) {
        return this.axisElement;
    }
}

