/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.uml.nattable.provider.UMLStereotypeRestrictedPropertyContentProvider;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class UMLStereotypePropertyAxisManager
extends AbstractAxisManager {
    public Command getComplementaryAddAxisCommand(EditingDomain domain, Collection<Object> objectToAdd) {
        HashSet appliedStereotypes = new HashSet();
        for (Object current : objectToAdd) {
            if (!(current instanceof Element)) continue;
            appliedStereotypes.addAll(((Element)current).getAppliedStereotypes());
        }
        HashSet allProperties = new HashSet();
        HashSet extendedMetaclass = new HashSet();
        for (Stereotype stereotype : appliedStereotypes) {
            allProperties.addAll(stereotype.getAllAttributes());
            extendedMetaclass.addAll(stereotype.getAllExtendedMetaclasses());
        }
        ArrayList<Object> propertiesToAdd = new ArrayList<Object>();
        for (Property property : allProperties) {
            Association association = property.getAssociation();
            if (association instanceof Extension) {
                Extension ext = (Extension)association;
                Class metaClass = ext.getMetaclass();
                if (property.getName().equals("base_" + metaClass.getName())) continue;
            }
            propertiesToAdd.add(property);
        }
        if (!propertiesToAdd.isEmpty()) {
            return this.getAddAxisCommand(domain, propertiesToAdd);
        }
        return null;
    }

    public Command getAddAxisCommand(EditingDomain domain, Collection<Object> objectToAdd) {
        ArrayList<String> allPropertyQN = new ArrayList<String>();
        for (Object object : objectToAdd) {
            if (!(object instanceof Property)) continue;
            allPropertyQN.add("property_of_stereotype:/" + ((NamedElement)object).getQualifiedName());
        }
        allPropertyQN.removeAll(this.getTableManager().getElementsList(this.getRepresentedContentProvider()));
        if (!allPropertyQN.isEmpty()) {
            ArrayList<FeatureIdAxis> toAdd = new ArrayList<FeatureIdAxis>();
            for (String propQN : allPropertyQN) {
                FeatureIdAxis newAxis = NattableaxisFactory.eINSTANCE.createFeatureIdAxis();
                newAxis.setElement(propQN);
                newAxis.setManager(this.representedAxisManager);
                toAdd.add(newAxis);
            }
            return AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), toAdd);
        }
        return null;
    }

    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        return false;
    }

    public boolean canInsertAxis(EditingDomain domain, Collection<Object> objectsToAdd, int index) {
        return false;
    }

    public IRestrictedContentProvider createPossibleAxisContentProvider(boolean isRestricted) {
        AbstractAxisProvider secondAxis = this.getTableManager().getHorizontalAxisProvider();
        if (secondAxis == this.getRepresentedContentProvider()) {
            secondAxis = this.getTableManager().getVerticalAxisProvider();
        }
        List allObjectsInTable = this.getTableManager().getElementsList(secondAxis);
        HashSet<Profile> profiles = new HashSet<Profile>();
        for (Object object : allObjectsInTable) {
            Object representedElement = AxisUtils.getRepresentedElement(object);
            if (!(representedElement instanceof Element)) continue;
            EList appliedStereotypes = ((Element)representedElement).getAppliedStereotypes();
            for (Stereotype stereotype : appliedStereotypes) {
                profiles.add((Profile)EcoreUtil.getRootContainer((EObject)stereotype));
            }
        }
        UMLStereotypeRestrictedPropertyContentProvider umlStereotypePropertyContentProvider = new UMLStereotypeRestrictedPropertyContentProvider(this, new ArrayList<Profile>(profiles));
        umlStereotypePropertyContentProvider.setRestriction(isRestricted);
        return umlStereotypePropertyContentProvider;
    }

    public Collection<Object> getAllPossibleAxis() {
        return this.getRootProfiles();
    }

    public Collection<Object> getRootProfiles() {
        EObject context = this.getTableManager().getTable().getContext();
        assert (context instanceof Element);
        EList allAppliedProfiles = ((Element)context).getNearestPackage().getAllAppliedProfiles();
        HashSet<Object> profiles = new HashSet<Object>();
        for (Profile profile : allAppliedProfiles) {
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)profile);
            profiles.add(rootContainer);
        }
        return profiles;
    }

    public Command getDestroyAxisCommand(EditingDomain domain, Collection<Object> umlProperties) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getRepresentedContentProvider());
        CompositeCommand compositeCommand = new CompositeCommand("Destroy IAxis Command");
        ArrayList<String> propIdToDestroy = new ArrayList<String>();
        for (Object current : umlProperties) {
            if (!(current instanceof Property) || !(((Property)current).eContainer() instanceof Stereotype)) continue;
            propIdToDestroy.add("property_of_stereotype:/" + ((NamedElement)current).getQualifiedName());
        }
        for (Object current : this.getRepresentedContentProvider().getAxis()) {
            String propId;
            if (!(current instanceof IdAxis) || !propIdToDestroy.contains(propId = AxisUtils.getPropertyId((Object)current))) continue;
            DestroyElementRequest request = new DestroyElementRequest((TransactionalEditingDomain)domain, (EObject)current, false);
            compositeCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        }
        if (!compositeCommand.isEmpty()) {
            return new GMFtoEMFCommandWrapper((ICommand)compositeCommand);
        }
        return null;
    }

    public Collection<Object> getAllManagedAxis() {
        HashSet<Object> eObjects = new HashSet<Object>();
        List elementList = this.getTableManager().getElementsList(this.getRepresentedContentProvider());
        for (Object element : elementList) {
            if (!(element instanceof IAxis) || ((IAxis)element).getManager() != this.representedAxisManager) continue;
            EObject context = this.getTableManager().getTable().getContext();
            String id = null;
            IdAxis idAxis = (IdAxis)element;
            id = idAxis.getElement();
            Property property = UMLTableUtils.getRealStereotypeProperty(context, id);
            if (property != null) {
                eObjects.add(property);
                continue;
            }
            eObjects.add(idAxis);
        }
        return eObjects;
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isSlave() {
        return true;
    }

    public boolean canEditAxisHeader() {
        return true;
    }

    public boolean canDestroyAxisElement(IAxis axis) {
        return false;
    }

    public boolean canDestroyAxisElement(Integer axisPosition) {
        return false;
    }

    public Command getDestroyAxisElementCommand(EditingDomain domain, Integer axisPosition) {
        return UnexecutableCommand.INSTANCE;
    }
}

