/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.cell;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.papyrus.infra.nattable.manager.cell.ICellManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypePropertyCellManager
implements ICellManager {
    public static final String STEREOTYPE_PREFIX = "property_of_stereotype:/";

    public boolean handles(Object obj1, Object obj2) {
        return this.organizeObject(obj1, obj2).size() == 2;
    }

    public Object getValue(Object obj1, Object obj2) {
        List<Object> elements = this.organizeObject(obj1, obj2);
        Object el = elements.get(0);
        if (el instanceof Element) {
            String propertyQualifiedName = (String)elements.get(1);
            propertyQualifiedName = propertyQualifiedName.substring(STEREOTYPE_PREFIX.length(), propertyQualifiedName.length());
            String stereotypeQN = NamedElementUtil.getParentQualifiedName((String)propertyQualifiedName);
            String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQualifiedName);
            Stereotype ste = ((Element)el).getAppliedStereotype(stereotypeQN);
            if (ste != null) {
                return ((Element)el).getValue(ste, propertyName);
            }
        }
        return NOT_AVALAIBLE;
    }

    protected List<Object> organizeObject(Object obj1, Object obj2) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (obj1 instanceof String && ((String)obj1).startsWith(STEREOTYPE_PREFIX)) {
            objects.add(obj2);
            objects.add(obj1);
        } else if (obj2 instanceof String && ((String)obj2).startsWith(STEREOTYPE_PREFIX)) {
            objects.add(obj1);
            objects.add(obj2);
        }
        return objects;
    }

    public void setValue(EditingDomain domain, Object rowElement, Object lineElement, Object newValue) {
    }

    public boolean isCellEditable(Object obj1, Object obj2) {
        return true;
    }

    public Command getSetValueCommand(EditingDomain domain, Object rowElement, Object lineElement, Object newValue) {
        return null;
    }

    public ICellEditor getCellEditor(Table table, Object obj1) {
        return null;
    }

    public boolean handlesAxisElement(Object obj) {
        return false;
    }
}

