/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.manager.cell;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.nattable.manager.cell.EMFFeatureValueCellManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLFeatureCellManager
extends EMFFeatureValueCellManager {
    protected List<Object> organizeUMLObject(Object obj1, Object obj2) {
        ArrayList<Object> objects = new ArrayList<Object>();
        if (obj1 instanceof IAxis) {
            obj1 = ((IAxis)obj1).getElement();
        }
        if (obj2 instanceof IAxis) {
            obj2 = ((IAxis)obj2).getElement();
        }
        if (obj2 instanceof Element) {
            objects.add(obj2);
            objects.add(obj1);
        } else if (obj1 instanceof Element) {
            objects.add(obj1);
            objects.add(obj2);
        }
        if (objects.size() == 2) {
            Object property = objects.get(1);
            String id = "";
            if (property instanceof IdAxis) {
                id = ((IdAxis)property).getElement();
                objects.remove(property);
                objects.add(id);
            } else if (property instanceof String) {
                id = (String)property;
            }
            if (!id.startsWith("property_of_stereotype:/")) {
                return Collections.emptyList();
            }
        } else {
            return Collections.emptyList();
        }
        return objects;
    }

    public boolean handles(Object obj1, Object obj2) {
        List objects = this.organizeObject(obj1, obj2);
        if (objects.size() == 2) {
            EStructuralFeature feature = (EStructuralFeature)objects.get(1);
            EObject featureContainer = feature.eContainer();
            if (UMLPackage.eINSTANCE.eContents().contains((Object)featureContainer)) {
                return true;
            }
        }
        return this.organizeUMLObject(obj1, obj2).size() == 2;
    }

    public boolean handlesAxisElement(Object obj) {
        if (super.handlesAxisElement(obj)) {
            if (obj instanceof EStructuralFeatureAxis) {
                obj = ((EStructuralFeatureAxis)obj).getElement();
            }
            EStructuralFeature feature = (EStructuralFeature)obj;
            EObject featureContainer = feature.eContainer();
            if (UMLPackage.eINSTANCE.eContents().contains((Object)featureContainer)) {
                return true;
            }
        }
        return false;
    }

    public Object getValue(Object obj1, Object obj2) {
        if (super.handles(obj1, obj2)) {
            return super.getValue(obj1, obj2);
        }
        List<Object> umlObjects = this.organizeUMLObject(obj1, obj2);
        if (umlObjects.size() == 2) {
            Element el = (Element)umlObjects.get(0);
            String id = (String)umlObjects.get(1);
            Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id);
            List<Stereotype> stereotypesWithThisProperty = UMLTableUtils.getAppliedSteretoypesWithThisProperty(el, id);
            if (stereotypesWithThisProperty.size() == 1) {
                return el.getValue(stereotypesWithThisProperty.get(0), prop.getName());
            }
            if (stereotypesWithThisProperty.size() > 1) {
                return "Several stereotypes with this feature are applied -> not yet managed";
            }
        }
        return NOT_AVALAIBLE;
    }

    public void setValue(EditingDomain domain, Object obj1, Object obj2, Object newValue) {
        if (super.handles(obj1, obj2)) {
            super.setValue(domain, obj1, obj2, newValue);
        } else {
            Command cmd = this.getSetValueCommand(domain, obj1, obj2, newValue);
            if (cmd != null) {
                domain.getCommandStack().execute(cmd);
            }
        }
    }

    public Command getSetValueCommand(EditingDomain domain, Object obj1, Object obj2, Object newValue) {
        if (super.handles(obj1, obj2)) {
            return super.getSetValueCommand(domain, obj1, obj2, newValue);
        }
        List<Object> umlObjects = this.organizeUMLObject(obj1, obj2);
        Element el = (Element)umlObjects.get(0);
        String id = (String)umlObjects.get(1);
        Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id);
        List<Stereotype> stereotypes = UMLTableUtils.getAppliedSteretoypesWithThisProperty(el, id);
        if (prop != null && stereotypes.size() == 1) {
            EObject stereotypeApplication = el.getStereotypeApplication(stereotypes.get(0));
            EStructuralFeature steApFeature = stereotypeApplication.eClass().getEStructuralFeature(prop.getName());
            SetRequest request = new SetRequest((TransactionalEditingDomain)domain, stereotypeApplication, steApFeature, newValue);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)stereotypeApplication);
            ICommand editCommand = provider.getEditCommand((IEditCommandRequest)request);
            return new GMFtoEMFCommandWrapper(editCommand);
        }
        return null;
    }

    public boolean isCellEditable(Object obj1, Object obj2) {
        if (super.handles(obj1, obj2)) {
            return super.isCellEditable(obj1, obj2);
        }
        List<Object> umlObjects = this.organizeUMLObject(obj1, obj2);
        Element el = (Element)umlObjects.get(0);
        String id = (String)umlObjects.get(1);
        switch (UMLTableUtils.getAppliedSteretoypesWithThisProperty(el, id).size()) {
            case 1: {
                Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)el, id);
                return !prop.isDerived();
            }
        }
        return false;
    }
}

