/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.provider;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.papyrus.infra.emf.nattable.provider.EMFFeatureHeaderLabelProvider;
import org.eclipse.papyrus.infra.emf.nattable.registry.EStructuralFeatureImageRegistry;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.FeatureLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ObjectLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderContextElement;
import org.eclipse.papyrus.infra.nattable.utils.LabelConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElement;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.uml.nattable.messages.Messages;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class StereotypePropertyHeaderLabelProvider
extends EMFFeatureHeaderLabelProvider {
    public static final String REQUIRED_PROFILE_NOT_AVALAIBLE = Messages.StereotypePropertyHeaderLabelProvider_RequiredProfileNotFound;
    public static final String AGGREG_SHARED = "icons/aggreg_shared.gif";

    public boolean accept(Object element) {
        if (element instanceof ILabelProviderContextElement) {
            Object value = ((ILabelProviderContextElement)element).getObject();
            String id = AxisUtils.getPropertyId((Object)value);
            return id != null && id.startsWith("property_of_stereotype:/");
        }
        return false;
    }

    public String getText(Object element) {
        String id;
        FeatureLabelProviderConfiguration conf = null;
        IConfigRegistry configRegistry = ((ILabelProviderContextElement)element).getConfigRegistry();
        if (element instanceof LabelProviderCellContextElement) {
            INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
            LabelStack labels = ((LabelProviderCellContextElement)element).getCell().getConfigLabels();
            if (labels.hasLabel("COLUMN_HEADER")) {
                conf = LabelConfigurationManagementUtils.getUsedColumnFeatureLabelConfiguration((Table)manager.getTable());
            } else if (labels.hasLabel("ROW_HEADER")) {
                conf = LabelConfigurationManagementUtils.getUsedRowFeatureLabelConfiguration((Table)manager.getTable());
            }
        }
        if (conf instanceof ObjectLabelProviderConfiguration && !((ObjectLabelProviderConfiguration)conf).isDisplayLabel()) {
            return "";
        }
        Object value = ((ILabelProviderContextElement)element).getObject();
        INattableModelManager modelManager = (INattableModelManager)this.getAxisContentProvider(configRegistry);
        EObject tableContext = modelManager.getTable().getContext();
        Property prop = UMLTableUtils.getRealStereotypeProperty(tableContext, id = AxisUtils.getPropertyId((Object)value));
        if (prop != null) {
            return this.getText(conf, configRegistry, prop.getName(), prop.getType(), prop.isDerived(), prop.getLower(), prop.getUpper());
        }
        id = id.replace("property_of_stereotype:/", "");
        return String.valueOf(id) + " " + REQUIRED_PROFILE_NOT_AVALAIBLE;
    }

    public Image getImage(Object element) {
        String id;
        Object value = ((ILabelProviderContextElement)element).getObject();
        IConfigRegistry configRegistry = ((ILabelProviderContextElement)element).getConfigRegistry();
        INattableModelManager modelManager = (INattableModelManager)this.getAxisContentProvider(configRegistry);
        FeatureLabelProviderConfiguration conf = null;
        if (element instanceof LabelProviderCellContextElement) {
            INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
            LabelStack labels = ((LabelProviderCellContextElement)element).getCell().getConfigLabels();
            if (labels.hasLabel("COLUMN_HEADER")) {
                conf = LabelConfigurationManagementUtils.getUsedColumnFeatureLabelConfiguration((Table)manager.getTable());
            } else if (labels.hasLabel("ROW_HEADER")) {
                conf = LabelConfigurationManagementUtils.getUsedRowFeatureLabelConfiguration((Table)manager.getTable());
            }
        }
        if (conf instanceof ObjectLabelProviderConfiguration && !((ObjectLabelProviderConfiguration)conf).isDisplayIcon()) {
            return null;
        }
        EObject tableContext = modelManager.getTable().getContext();
        Property prop = UMLTableUtils.getRealStereotypeProperty(tableContext, id = AxisUtils.getPropertyId((Object)value));
        if (prop != null) {
            Type type = prop.getType();
            if (type instanceof DataType) {
                return EStructuralFeatureImageRegistry.getAttributeIcon();
            }
            switch (prop.getAggregation().getValue()) {
                case 0: {
                    return EStructuralFeatureImageRegistry.getLinkIcon();
                }
                case 2: {
                    return EStructuralFeatureImageRegistry.getAggregIcon();
                }
                case 1: {
                    return Activator.getDefault().getImage("org.eclipse.papyrus.uml.nattable", AGGREG_SHARED);
                }
            }
        }
        return null;
    }
}

