/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.widgets.providers.AbstractRestrictedContentProvider;
import org.eclipse.papyrus.uml.nattable.manager.axis.UMLFeatureAxisManager;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLFeatureRestrictedContentProvider
extends AbstractRestrictedContentProvider {
    private final UMLFeatureAxisManager umlFeatureAxisManager;

    public UMLFeatureRestrictedContentProvider(UMLFeatureAxisManager umlFeatureAxisManager, boolean isRestricted) {
        super(isRestricted);
        this.umlFeatureAxisManager = umlFeatureAxisManager;
    }

    public Object[] getElements(Object inputElement) {
        Collection<Object> elementsToShow = this.umlFeatureAxisManager.getAllPossibleAxis();
        return elementsToShow.toArray();
    }

    protected AbstractAxisProvider getManagedAxisProvider() {
        return this.umlFeatureAxisManager.getRepresentedContentProvider();
    }

    protected AbstractAxisProvider getSecondAxisProvider() {
        AbstractAxisProvider secondAxisProvider = this.umlFeatureAxisManager.getTableManager().getVerticalAxisProvider();
        if (secondAxisProvider == this.umlFeatureAxisManager) {
            secondAxisProvider = this.umlFeatureAxisManager.getTableManager().getHorizontalAxisProvider();
        }
        return secondAxisProvider;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<EClassifier> asList = new ArrayList<EClassifier>();
        if (parentElement instanceof EClass) {
            EClass eClass = (EClass)parentElement;
            asList.addAll((Collection<EClassifier>)eClass.getEStructuralFeatures());
            return asList.toArray();
        }
        if (parentElement instanceof EPackage) {
            EPackage ePackage = (EPackage)parentElement;
            Object eClassifiers = null;
            if (this.isRestricted) {
                eClassifiers = new HashSet();
                AbstractAxisProvider axisProvider = this.umlFeatureAxisManager.getTableManager().getHorizontalAxisProvider();
                if (axisProvider == this.umlFeatureAxisManager.getRepresentedContentProvider()) {
                    axisProvider = this.umlFeatureAxisManager.getTableManager().getVerticalAxisProvider();
                }
                List elementsList = this.umlFeatureAxisManager.getTableManager().getElementsList(axisProvider);
                for (Object object : elementsList) {
                    if (!(object instanceof EObject)) continue;
                    EObject eObject = (EObject)object;
                    if (eObject instanceof EObjectAxis) {
                        eObject = ((EObjectAxis)eObject).getElement();
                    }
                    EClass eClass = eObject.eClass();
                    eClassifiers.add(eClass);
                    eClassifiers.addAll(eClass.getEAllSuperTypes());
                }
            } else {
                eClassifiers = ePackage.getEClassifiers();
            }
            Iterator iterator = eClassifiers.iterator();
            while (iterator.hasNext()) {
                EClassifier eClassifier = (EClassifier)iterator.next();
                if (!(eClassifier instanceof EClass)) continue;
                asList.add(eClassifier);
            }
            return asList.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)element;
            return feature.getEContainingClass();
        }
        if (element instanceof EClass) {
            EClass eClass = (EClass)element;
            return eClass.getEPackage();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof EClass) {
            EClass eClass = (EClass)element;
            boolean hasChildren = !eClass.getEStructuralFeatures().isEmpty();
            return hasChildren;
        }
        if (element instanceof EPackage) {
            EPackage ePackage = (EPackage)element;
            EList eClassifiers = ePackage.getEClassifiers();
            for (EClassifier eClassifier : eClassifiers) {
                if (!(eClassifier instanceof EClass)) continue;
                return true;
            }
            return false;
        }
        if (element instanceof EStructuralFeature) {
            return false;
        }
        return false;
    }

    public Object[] getElements() {
        return this.getElements(null);
    }

    public boolean isValidValue(Object element) {
        return element instanceof EStructuralFeature && UMLPackage.eINSTANCE.eContents().contains((Object)((EObject)element).eContainer());
    }
}

