/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.uml.nattable.manager.axis.UMLStereotypePropertyAxisManager;
import org.eclipse.papyrus.uml.tools.providers.UMLStereotypePropertyContentProvider;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class UMLStereotypeRestrictedPropertyContentProvider
extends UMLStereotypePropertyContentProvider
implements IRestrictedContentProvider {
    private boolean isRestricted;
    private UMLStereotypePropertyAxisManager umlStereotypePropertyManager;

    public UMLStereotypeRestrictedPropertyContentProvider(UMLStereotypePropertyAxisManager umlStereotypePropertyManager, List<Profile> profiles) {
        super(profiles);
        this.umlStereotypePropertyManager = umlStereotypePropertyManager;
    }

    public void setRestriction(boolean isRestricted) {
        this.isRestricted = isRestricted;
    }

    protected AbstractAxisProvider getOtherAxisProvider() {
        AbstractAxisProvider currentProvider = this.umlStereotypePropertyManager.getRepresentedContentProvider();
        if (currentProvider == this.umlStereotypePropertyManager.getTableManager().getVerticalAxisProvider()) {
            return this.umlStereotypePropertyManager.getTableManager().getHorizontalAxisProvider();
        }
        return this.umlStereotypePropertyManager.getTableManager().getVerticalAxisProvider();
    }

    public Object[] getChildren(Object parentElement) {
        if (!(parentElement instanceof Package) && !(parentElement instanceof Stereotype)) {
            return new Object[0];
        }
        Object[] children = super.getChildren(parentElement);
        if (!this.isRestricted || !(parentElement instanceof Package)) {
            return children;
        }
        HashSet restrictedStereotypes = new HashSet();
        AbstractAxisProvider otherAxisProvider = this.getOtherAxisProvider();
        List elementsList = this.umlStereotypePropertyManager.getTableManager().getElementsList(otherAxisProvider);
        for (Object object : elementsList) {
            Iterator representedElement = AxisUtils.getRepresentedElement(object);
            if (!(representedElement instanceof Element)) continue;
            restrictedStereotypes.addAll(((Element)representedElement).getAppliedStereotypes());
        }
        HashSet<Stereotype> superSte = new HashSet<Stereotype>();
        for (Stereotype ste : restrictedStereotypes) {
            for (Classifier classifier : ste.getGenerals()) {
                if (!(classifier instanceof Stereotype)) continue;
                superSte.add((Stereotype)classifier);
            }
        }
        restrictedStereotypes.addAll(superSte);
        HashSet toKeep = new HashSet();
        toKeep.addAll(restrictedStereotypes);
        for (Stereotype stereotype : restrictedStereotypes) {
            toKeep.addAll(EMFHelper.getContainmentPath((EObject)stereotype));
        }
        ArrayList<Object> returnedValues = new ArrayList<Object>();
        returnedValues.addAll(Arrays.asList(children));
        returnedValues.retainAll(toKeep);
        return returnedValues.toArray();
    }
}

