/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class UMLTableUtils {
    public static final String PROPERTY_OF_STEREOTYPE_PREFIX = "property_of_stereotype:/";

    private UMLTableUtils() {
    }

    public static Property getRealStereotypeProperty(EObject eobject, String id) {
        assert (id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        if (eobject instanceof Element) {
            Element element = (Element)eobject;
            String propertyQN = id.replace(PROPERTY_OF_STEREOTYPE_PREFIX, "");
            String propertyName = NamedElementUtil.getNameFromQualifiedName((String)propertyQN);
            String stereotypeQN = NamedElementUtil.getParentQualifiedName((String)propertyQN);
            String stereotypeName = NamedElementUtil.getNameFromQualifiedName((String)stereotypeQN);
            String profileQN = NamedElementUtil.getParentQualifiedName((String)stereotypeQN);
            Profile profile = element.getNearestPackage().getAppliedProfile(profileQN, true);
            if (profile != null) {
                Stereotype ste = profile.getOwnedStereotype(stereotypeName);
                return (Property)ste.getMember(propertyName);
            }
        }
        return null;
    }

    public static final List<Stereotype> getAppliedSteretoypesWithThisProperty(Element element, String id) {
        assert (id.startsWith(PROPERTY_OF_STEREOTYPE_PREFIX));
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        Property prop = UMLTableUtils.getRealStereotypeProperty((EObject)element, id);
        if (prop instanceof Property) {
            for (Stereotype current : element.getAppliedStereotypes()) {
                if (!current.getAllAttributes().contains((Object)prop)) continue;
                stereotypes.add(current);
            }
        }
        return stereotypes;
    }
}

