/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.common.utils.TableEditorInput;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.NattableconfigurationPackage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractEMFNattableEditor
extends EditorPart {
    protected ServicesRegistry servicesRegistry;
    protected final INattableModelManager tableManager;
    private PartNameSynchronizer synchronizer;

    public AbstractEMFNattableEditor(ServicesRegistry servicesRegistry, Table rawModel) {
        this.servicesRegistry = servicesRegistry;
        this.tableManager = new NattableModelManager(rawModel);
        this.synchronizer = new PartNameSynchronizer(rawModel);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        TableEditorInput tableEditorInput = new TableEditorInput(this.tableManager.getTable(), this.getEditingDomain());
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(tableEditorInput);
        this.setPartName(this.tableManager.getTable().getName());
    }

    public EditingDomain getEditingDomain() {
        try {
            return ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        this.tableManager.createNattable(parent, 0, this.getSite());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == INattableModelManager.class) {
            return this.tableManager;
        }
        if (adapter == Table.class && this.tableManager != null) {
            return this.tableManager.getTable();
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        this.tableManager.dispose();
        this.synchronizer.dispose();
        super.dispose();
    }

    public class PartNameSynchronizer {
        private Table papyrusTable;
        private final Adapter tableNameListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeature() == NattableconfigurationPackage.eINSTANCE.getTableNamedElement_Name()) {
                    AbstractEMFNattableEditor.this.setPartName(PartNameSynchronizer.this.papyrusTable.getName());
                }
            }
        };

        public PartNameSynchronizer(Table papyrusTable) {
            this.setTable(papyrusTable);
        }

        public void dispose() {
            this.papyrusTable.eAdapters().remove((Object)this.tableNameListener);
            this.papyrusTable = null;
        }

        public void setTable(Table papyrusTable) {
            if (this.papyrusTable != null) {
                papyrusTable.eAdapters().remove((Object)this.tableNameListener);
            }
            this.papyrusTable = papyrusTable;
            AbstractEMFNattableEditor.this.setPartName(papyrusTable.getName());
            papyrusTable.eAdapters().add((Object)this.tableNameListener);
        }
    }
}

