/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.factory;

import java.lang.reflect.Constructor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.extension.diagrameditor.AbstractEditorFactory;
import org.eclipse.papyrus.infra.core.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.common.editor.NatTableEditor;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;

public class NattableEditorFactory
extends AbstractEditorFactory {
    public NattableEditorFactory() {
        super(NatTableEditor.class, "");
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        return new NattableEditorModel(pageIdentifier, this.getServiceRegistry());
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        return pageIdentifier instanceof Table;
    }

    class NattableEditorModel
    implements IEditorModel {
        private ServicesRegistry servicesRegistry;
        private IEditorPart editor;
        private Table rawModel;

        public NattableEditorModel(Object pageIdentifier, ServicesRegistry servicesRegistry) {
            this.rawModel = (Table)pageIdentifier;
            this.servicesRegistry = servicesRegistry;
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            try {
                IEditorPart newEditor;
                Constructor c = NattableEditorFactory.this.getDiagramClass().getConstructor(ServicesRegistry.class, Table.class);
                this.editor = newEditor = (IEditorPart)c.newInstance(this.servicesRegistry, this.rawModel);
                return this.editor;
            }
            catch (Exception e) {
                throw new PartInitException("Can't create Nattable", (Throwable)e);
            }
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = NattableEditorFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)this.servicesRegistry.getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }

        public Object getRawModel() {
            return this.rawModel;
        }

        public Image getTabIcon() {
            return org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(this.rawModel.getTableConfiguration().getIconPath());
        }

        public String getTabTitle() {
            return this.rawModel.getName();
        }
    }
}

