/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.infra.nattable.common.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.nattableconfiguration.NattableConfigurationRegistry;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ChooseNattableConfigWizardPage
extends WizardPage {
    private Map<TableConfiguration, Integer> selectedConfigs = new HashMap<TableConfiguration, Integer>();
    private Map<TableConfiguration, String> tableNames = new HashMap<TableConfiguration, String>();
    private Object context;
    private static final Image CHECKED = Activator.getDefault().getImage("org.eclipse.papyrus.infra.nattable.common", "icons/checked.gif");
    private static final Image UNCHECKED = Activator.getDefault().getImage("org.eclipse.papyrus.infra.nattable.common", "icons/unchecked.gif");

    protected ChooseNattableConfigWizardPage(String pageName, EObject context) {
        super(pageName);
        this.context = context;
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.createTableViewer(container);
        this.setControl((Control)container);
    }

    public void createTableViewer(final Composite container) {
        final TableViewer viewer = new TableViewer(container, 68354);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        TableViewerColumn colCheckbox = this.createTableViewerColumn("", 20, viewer);
        Collection<TableConfiguration> configs = this.loadConfigs();
        colCheckbox.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                if (ChooseNattableConfigWizardPage.this.selectedConfigs.containsKey(element)) {
                    return CHECKED;
                }
                return UNCHECKED;
            }
        });
        colCheckbox.setEditingSupport(new EditingSupport((ColumnViewer)viewer){
            private CheckboxCellEditor checkboxCellEditor;

            protected void setValue(Object element, Object value) {
                if (this.checkboxCellEditor.getValue() == Boolean.TRUE) {
                    ChooseNattableConfigWizardPage.this.selectedConfigs.put((TableConfiguration)element, 1);
                } else {
                    ChooseNattableConfigWizardPage.this.selectedConfigs.remove(element);
                }
                viewer.update(element, null);
            }

            protected Object getValue(Object element) {
                return ChooseNattableConfigWizardPage.this.selectedConfigs.containsKey(element);
            }

            protected CellEditor getCellEditor(Object element) {
                this.checkboxCellEditor = new CheckboxCellEditor(container, 40);
                return this.checkboxCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn colType = this.createTableViewerColumn(Messages.ChooseNattableConfigWizardPage_6, 200, viewer);
        colType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TableConfiguration tc = (TableConfiguration)element;
                return tc.getType();
            }

            public Image getImage(Object element) {
                TableConfiguration tc = (TableConfiguration)element;
                Image image = Activator.getDefault().getImage(tc.getIconPath());
                return image;
            }
        });
        TableViewerColumn colName = this.createTableViewerColumn(Messages.ChooseNattableConfigWizardPage_7, 100, viewer);
        colName.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

            protected void setValue(Object element, Object value) {
                ChooseNattableConfigWizardPage.this.tableNames.put((TableConfiguration)element, (String)value);
                viewer.update(element, null);
            }

            protected Object getValue(Object element) {
                if (ChooseNattableConfigWizardPage.this.tableNames.containsKey(element)) {
                    return ChooseNattableConfigWizardPage.this.tableNames.get(element);
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)viewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return (String)ChooseNattableConfigWizardPage.this.tableNames.get(element);
            }
        });
        TableViewerColumn colQuantity = this.createTableViewerColumn(Messages.ChooseNattableConfigWizardPage_9, 70, viewer);
        colQuantity.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

            protected void setValue(Object element, Object value) {
                ChooseNattableConfigWizardPage.this.selectedConfigs.put((TableConfiguration)element, Integer.parseInt((String)value));
                viewer.update(element, null);
            }

            protected Object getValue(Object element) {
                if (ChooseNattableConfigWizardPage.this.selectedConfigs.containsKey(element)) {
                    return ((Integer)ChooseNattableConfigWizardPage.this.selectedConfigs.get(element)).toString();
                }
                return "0";
            }

            protected CellEditor getCellEditor(Object element) {
                TextCellEditor textCellEditor = new TextCellEditor((Composite)viewer.getTable());
                textCellEditor.setValidator(new ICellEditorValidator(){

                    public String isValid(Object value) {
                        if (!(value instanceof Integer)) {
                            return null;
                        }
                        return value.toString();
                    }
                });
                return textCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        colQuantity.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (ChooseNattableConfigWizardPage.this.selectedConfigs.containsKey(element)) {
                    return ((Integer)ChooseNattableConfigWizardPage.this.selectedConfigs.get(element)).toString();
                }
                return "";
            }
        });
        TableViewerColumn colDescription = this.createTableViewerColumn(Messages.ChooseNattableConfigWizardPage_12, 400, viewer);
        colDescription.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TableConfiguration tc = (TableConfiguration)element;
                return tc.getDescription();
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ChooseNattableConfigWizardPage.this.selectedConfigs.size() > 0) {
                    ChooseNattableConfigWizardPage.this.setPageComplete(true);
                } else {
                    ChooseNattableConfigWizardPage.this.setPageComplete(false);
                }
            }
        });
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.setInput(configs);
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, TableViewer viewer) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(false);
        column.setMoveable(false);
        return viewerColumn;
    }

    public Collection<TableConfiguration> loadConfigs() {
        ArrayList<TableConfiguration> tableConfigurations = new ArrayList<TableConfiguration>(NattableConfigurationRegistry.INSTANCE.getTableConfigurations());
        ArrayList<TableConfiguration> tableConfigurationsToRemove = new ArrayList<TableConfiguration>();
        for (TableConfiguration tableConfiguration : tableConfigurations) {
            if (NattableConfigurationRegistry.INSTANCE.canCreateTable(tableConfiguration.getType(), this.context).isOK()) {
                this.tableNames.put(tableConfiguration, tableConfiguration.getName());
                continue;
            }
            tableConfigurationsToRemove.add(tableConfiguration);
        }
        tableConfigurations.removeAll(tableConfigurationsToRemove);
        return tableConfigurations;
    }

    public Map<TableConfiguration, Integer> getSelectedConfigs() {
        return this.selectedConfigs;
    }

    public Map<TableConfiguration, String> getTableNames() {
        return this.tableNames;
    }
}

