/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.nattable.manager.axis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractSynchronizedOnFeatureAxisManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.sysml.service.types.matcher.AllocateMatcher;
import org.eclipse.uml2.uml.UMLPackage;

public class AllocateAxisManager
extends AbstractSynchronizedOnFeatureAxisManager {
    protected void addContextFeatureValueListener() {
        this.featureListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == AllocateAxisManager.this.currentListenFeature || msg.getFeature() == UMLPackage.eINSTANCE.getPackage_PackagedElement()) {
                    AllocateAxisManager.this.getTableManager().updateAxisContents(AllocateAxisManager.this.getRepresentedContentProvider());
                }
            }
        };
        this.getTableContext().eAdapters().add((Object)this.featureListener);
    }

    public void dispose() {
        this.getTableContext().eAdapters().remove((Object)this.featureListener);
        super.dispose();
    }

    public boolean canCreateAxisElement(String elementId) {
        return ((ISpecializationType)SysMLElementTypes.ALLOCATE).getId().equals(elementId);
    }

    protected List<Object> filterObject(List<?> objects) {
        ArrayList<Object> interestingObjects = new ArrayList<Object>();
        AllocateMatcher matcher = new AllocateMatcher();
        for (Object object : objects) {
            if (!(object instanceof EObject) || !matcher.matches((EObject)object)) continue;
            interestingObjects.add(object);
        }
        return interestingObjects;
    }

    public boolean canDestroyAxisElement(Integer axisPosition) {
        Object current = this.getElements().get(axisPosition);
        if (current instanceof EObjectAxis) {
            return !EMFHelper.isReadOnly((EObject)((EObjectAxis)current).getElement());
        }
        if (current instanceof EObject) {
            return !EMFHelper.isReadOnly((EObject)((EObject)current));
        }
        return false;
    }

    public Command getDestroyAxisElementCommand(EditingDomain domain, Integer axisPosition) {
        Object current = this.getElements().get(axisPosition);
        EObject elementToDestroy = null;
        if (current instanceof EObjectAxis) {
            elementToDestroy = ((EObjectAxis)current).getElement();
        } else if (current instanceof EObject) {
            elementToDestroy = (EObject)current;
        }
        if (elementToDestroy != null) {
            DestroyElementRequest request = new DestroyElementRequest((TransactionalEditingDomain)this.getContextEditingDomain(), elementToDestroy, false);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)elementToDestroy);
            return new GMFtoEMFCommandWrapper(provider.getEditCommand((IEditCommandRequest)request));
        }
        return null;
    }
}

