/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.nattable.manager.axis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractSynchronizedOnFeatureAxisManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.sysml.service.types.matcher.RequirementMatcher;
import org.eclipse.uml2.uml.UMLPackage;

public class RequirementAxisManager
extends AbstractSynchronizedOnFeatureAxisManager {
    protected void addContextFeatureValueListener() {
        this.featureListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == RequirementAxisManager.this.currentListenFeature || msg.getFeature() == UMLPackage.eINSTANCE.getPackage_PackagedElement()) {
                    RequirementAxisManager.this.getTableManager().updateAxisContents(RequirementAxisManager.this.getRepresentedContentProvider());
                }
            }
        };
        this.getTableContext().eAdapters().add((Object)this.featureListener);
    }

    public void dispose() {
        this.getTableContext().eAdapters().remove((Object)this.featureListener);
        super.dispose();
    }

    public boolean canCreateAxisElement(String elementId) {
        return ((ISpecializationType)SysMLElementTypes.REQUIREMENT).getId().equals(elementId);
    }

    protected List<Object> filterObject(List<?> objects) {
        ArrayList<Object> interestingObjects = new ArrayList<Object>();
        RequirementMatcher matcher = new RequirementMatcher();
        for (Object object : objects) {
            if (!(object instanceof EObject) || !matcher.matches((EObject)object)) continue;
            interestingObjects.add(object);
        }
        return interestingObjects;
    }

    public boolean canDestroyAxisElement(Integer axisPosition) {
        Object current = this.getElements().get(axisPosition);
        if (current instanceof EObjectAxis) {
            return !EMFHelper.isReadOnly((EObject)((EObjectAxis)current).getElement());
        }
        return false;
    }

    public Command getDestroyAxisElementCommand(EditingDomain domain, Integer axisPosition) {
        Object current = this.getElements().get(axisPosition);
        if (current instanceof EObjectAxis) {
            EObject element = ((EObjectAxis)current).getElement();
            DestroyElementRequest request = new DestroyElementRequest((TransactionalEditingDomain)this.getContextEditingDomain(), element, false);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)element);
            return new GMFtoEMFCommandWrapper(provider.getEditCommand((IEditCommandRequest)request));
        }
        return null;
    }
}

