/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.validation.problems;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ESeverity implements Enumerator
{
    OK(0, "OK", "OK"),
    INFO(1, "INFO", "INFO"),
    WARNING(2, "WARNING", "WARNING"),
    ERROR(4, "ERROR", "ERROR"),
    CANCEL(8, "CANCEL", "CANCEL");

    public static final int OK_VALUE = 0;
    public static final int INFO_VALUE = 1;
    public static final int WARNING_VALUE = 2;
    public static final int ERROR_VALUE = 4;
    public static final int CANCEL_VALUE = 8;
    private static final ESeverity[] VALUES_ARRAY;
    public static final List<ESeverity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ESeverity[]{OK, INFO, WARNING, ERROR, CANCEL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ESeverity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ESeverity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ESeverity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ESeverity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ESeverity get(int value) {
        switch (value) {
            case 0: {
                return OK;
            }
            case 1: {
                return INFO;
            }
            case 2: {
                return WARNING;
            }
            case 4: {
                return ERROR;
            }
            case 8: {
                return CANCEL;
            }
        }
        return null;
    }

    private ESeverity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

