/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.converter.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiPackage;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.nattableconfiguration.NattableConfigurationRegistry;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.uml.nattable.converter.Activator;
import org.eclipse.papyrus.uml.nattable.converter.messages.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ConvertOldTableHandler
extends AbstractHandler {
    public static final String OLD_DEFAULT_TABLE_TYPE = "PapyrusDefaultTable";
    public static final String OLD_REQUIREMENT_TABLE = "PapyrusRequirementTable";
    public static final String OLD_ALLOCATION_TABLE = "PapyrusAllocationTable";
    public static final String PAPYRUS_NEW_DEFAULT_TABLE = "PapyrusGenericTable";
    public static final String PAPYRUS_NEW_REQUIREMENT_TABLE = "PapyrusSysMLRequirementTable";
    public static final String PAPYRUS_NEW_ALLOCATION_TABLE = "PapyrusSysMLAllocationTable";
    protected List<PapyrusTableInstance> oldPapyrusTableInstance;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean destroyOldTable = false;
        boolean replaceOldRequirementTableByNewRequirementTable = false;
        boolean replaceOldSysMLAllocationTableByNewSysMLAllocationTable = false;
        boolean selectionContainsRequirementsTable = false;
        boolean selectionContainsAllocationTable = false;
        boolean selectionContainsCustomTableKind = false;
        boolean convertCustomTabletoGenericTable = false;
        List<PapyrusTableInstance> oldTables = this.oldPapyrusTableInstance;
        if (!oldTables.isEmpty()) {
            MessageDialog dialog;
            for (PapyrusTableInstance oldTable : oldTables) {
                String type = oldTable.getType();
                if (OLD_REQUIREMENT_TABLE.equals(type)) {
                    selectionContainsRequirementsTable = true;
                }
                if (OLD_ALLOCATION_TABLE.equals(type)) {
                    selectionContainsAllocationTable = true;
                }
                if (selectionContainsAllocationTable && selectionContainsRequirementsTable) break;
            }
            String dialogTitle = Messages.ConvertOldTableHandler_ConvertOldTableQuestion;
            boolean answer = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)dialogTitle, (String)Messages.ConvertOldTableHandler_AdvicesForUser);
            if (!answer) {
                return null;
            }
            String dialogGlobalMessage = Messages.ConvertOldTableHandler_DialogMessage;
            String dialogAllocationMessage = String.format(dialogGlobalMessage, "Allocation");
            String dialogRequirementMessage = String.format(dialogGlobalMessage, "Requirement");
            if (selectionContainsAllocationTable) {
                dialog = new MessageDialog(Display.getDefault().getActiveShell(), dialogTitle, null, dialogAllocationMessage, 6, new String[]{Messages.ConvertOldTableHandler_ConvertToNewAllocationTable, Messages.ConvertOldTableHandler_ConvertToNewUMLGenericTable, Messages.ConvertOldTableHandler_Cancel}, 0);
                switch (dialog.open()) {
                    case 0: {
                        replaceOldSysMLAllocationTableByNewSysMLAllocationTable = true;
                        break;
                    }
                    case 1: {
                        replaceOldSysMLAllocationTableByNewSysMLAllocationTable = false;
                        break;
                    }
                    case 2: {
                        return null;
                    }
                }
            }
            if (selectionContainsRequirementsTable) {
                dialog = new MessageDialog(Display.getDefault().getActiveShell(), dialogTitle, null, dialogRequirementMessage, 6, new String[]{Messages.ConvertOldTableHandler_ConvertToNewRequirementTable, Messages.ConvertOldTableHandler_ConvertToNewUMLGenericTable, Messages.ConvertOldTableHandler_Cancel}, 0);
                switch (dialog.open()) {
                    case 0: {
                        replaceOldRequirementTableByNewRequirementTable = true;
                        break;
                    }
                    case 1: {
                        replaceOldRequirementTableByNewRequirementTable = false;
                        break;
                    }
                    case 2: {
                        return null;
                    }
                }
            }
            if (selectionContainsCustomTableKind) {
                convertCustomTabletoGenericTable = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)dialogTitle, (String)Messages.ConvertOldTableHandler_QuestionAboutCustomTable);
            }
            destroyOldTable = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.ConvertOldTableHandler_ConvertOldTableQuestion, (String)Messages.ConvertOldTableHandler_DestroyTheTableAtTheEndQuestion);
            CompoundCommand convertCommand = new CompoundCommand();
            TransactionalEditingDomain domain = null;
            try {
                domain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)((EObject)oldTables.get(0)));
            }
            catch (ServiceException e1) {
                Activator.log.error("Can't found the editing domain", (Throwable)e1);
            }
            for (PapyrusTableInstance oldTable : oldTables) {
                String type = oldTable.getType();
                Table newTable = null;
                if (OLD_DEFAULT_TABLE_TYPE.equals(type)) {
                    newTable = this.getCreateUMLGenericTableCommand(oldTable);
                } else if (OLD_REQUIREMENT_TABLE.equals(type)) {
                    newTable = replaceOldRequirementTableByNewRequirementTable ? this.getCreateSysMLRequirementTableCommand(oldTable) : this.getCreateUMLGenericTableCommand(oldTable);
                } else if (OLD_ALLOCATION_TABLE.equals(type)) {
                    newTable = replaceOldSysMLAllocationTableByNewSysMLAllocationTable ? this.getCreateSysMLAllocationTableCommand(oldTable) : this.getCreateUMLGenericTableCommand(oldTable);
                } else {
                    if (!convertCustomTabletoGenericTable) continue;
                    newTable = this.getCreateUMLGenericTableCommand(oldTable);
                }
                Resource notationResource = ((ModelSet)oldTable.eResource().getResourceSet()).getAssociatedResource((EObject)oldTable, "notation", true);
                IPageManager manager = this.getPageManager((EObject)oldTable);
                convertCommand.append(this.getAddToResourceCommand(domain, notationResource, newTable));
                Assert.isNotNull((Object)manager);
                convertCommand.append(this.getAddToPageManagerCommand(domain, manager, newTable));
                Command tmp = this.getReplaceExistingTableCommand(domain, oldTable, newTable);
                if (tmp != null) {
                    convertCommand.append(tmp);
                }
                if (!destroyOldTable) continue;
                convertCommand.append(this.getDestroyOldTableCommand(domain, oldTable));
            }
            if (!convertCommand.isEmpty()) {
                domain.getCommandStack().execute((Command)convertCommand);
            }
            this.oldPapyrusTableInstance.clear();
        }
        return null;
    }

    protected Command getDestroyOldTableCommand(TransactionalEditingDomain domain, PapyrusTableInstance oldTable) {
        DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)oldTable, false);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)oldTable);
        return new GMFtoEMFCommandWrapper(provider.getEditCommand((IEditCommandRequest)request));
    }

    protected Table getCreateUMLGenericTableCommand(PapyrusTableInstance oldTable) {
        URI uri = NattableConfigurationRegistry.INSTANCE.getConfigurationURI(PAPYRUS_NEW_DEFAULT_TABLE);
        ResourceSet resourceSet = oldTable.eResource().getResourceSet();
        TableConfiguration configuration = (TableConfiguration)resourceSet.getResource(uri, true).getContents().get(0);
        Table newTable = this.getCreateTableFromConfiguration(oldTable, configuration);
        AxisManagerRepresentation representation = (AxisManagerRepresentation)configuration.getRowHeaderAxisConfiguration().getAxisManagers().get(0);
        for (EObject element : oldTable.getTable().getElements()) {
            EObjectAxis axis = NattableaxisFactory.eINSTANCE.createEObjectAxis();
            axis.setElement(element);
            axis.setManager(representation);
            newTable.getCurrentRowAxisProvider().getAxis().add((Object)axis);
        }
        return newTable;
    }

    protected Table getCreateSysMLRequirementTableCommand(PapyrusTableInstance oldTable) {
        URI uri = NattableConfigurationRegistry.INSTANCE.getConfigurationURI(PAPYRUS_NEW_REQUIREMENT_TABLE);
        ResourceSet resourceSet = oldTable.eResource().getResourceSet();
        TableConfiguration configuration = (TableConfiguration)resourceSet.getResource(uri, true).getContents().get(0);
        return this.getCreateTableFromConfiguration(oldTable, configuration);
    }

    protected Table getCreateSysMLAllocationTableCommand(PapyrusTableInstance oldTable) {
        URI uri = NattableConfigurationRegistry.INSTANCE.getConfigurationURI(PAPYRUS_NEW_ALLOCATION_TABLE);
        ResourceSet resourceSet = oldTable.eResource().getResourceSet();
        TableConfiguration configuration = (TableConfiguration)resourceSet.getResource(uri, true).getContents().get(0);
        return this.getCreateTableFromConfiguration(oldTable, configuration);
    }

    protected Table getCreateTableFromConfiguration(PapyrusTableInstance oldTable, TableConfiguration tableConfiguration) {
        URI uri = NattableConfigurationRegistry.INSTANCE.getConfigurationURI(PAPYRUS_NEW_DEFAULT_TABLE);
        ResourceSet resourceSet = oldTable.eResource().getResourceSet();
        TableConfiguration configuration = (TableConfiguration)resourceSet.getResource(uri, true).getContents().get(0);
        return TableHelper.createTable((TableConfiguration)configuration, (EObject)oldTable.getTable().getContext(), (String)(String.valueOf(oldTable.getName()) + "(Converted)"), (String)oldTable.getTable().getDescription());
    }

    protected Command getAddToPageManagerCommand(TransactionalEditingDomain domain, final IPageManager manager, final Table newTable) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                manager.addPage((Object)newTable);
            }
        };
    }

    protected Command getAddToResourceCommand(TransactionalEditingDomain domain, final Resource notationResource, final Table newTable) {
        return new RecordingCommand(domain){

            protected void doExecute() {
                notationResource.getContents().add((Object)newTable);
            }
        };
    }

    protected Command getReplaceExistingTableCommand(TransactionalEditingDomain domain, final PapyrusTableInstance oldTable, final Table newTable) {
        CompoundCommand compoundCommand = new CompoundCommand("Replace Old table Command");
        ECrossReferenceAdapter crossReferenceAdapter = CrossReferenceAdapter.getCrossReferenceAdapter((Notifier)oldTable);
        Collection settings = crossReferenceAdapter.getNonNavigableInverseReferences((EObject)oldTable);
        for (final EStructuralFeature.Setting setting : settings) {
            EStructuralFeature feature = setting.getEStructuralFeature();
            if (feature == DiPackage.eINSTANCE.getPageRef_EmfPageIdentifier()) continue;
            RecordingCommand cmd = new RecordingCommand(domain){

                protected void doExecute() {
                    EcoreUtil.replace((EStructuralFeature.Setting)setting, (Object)oldTable, (Object)newTable);
                }
            };
            compoundCommand.append((Command)cmd);
        }
        if (compoundCommand.isEmpty()) {
            return null;
        }
        return compoundCommand;
    }

    protected IPageManager getPageManager(EObject eobject) {
        IPageManager manager = null;
        try {
            manager = ServiceUtilsForEObject.getInstance().getIPageManager((Object)eobject);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return manager;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection;
        this.oldPapyrusTableInstance = new ArrayList<PapyrusTableInstance>();
        if (evaluationContext instanceof IEvaluationContext && (selection = ((IEvaluationContext)evaluationContext).getDefaultVariable()) instanceof Collection) {
            Object current;
            List currentSelection;
            List list = currentSelection = selection instanceof List ? (List)selection : new ArrayList((Collection)selection);
            if (currentSelection.size() == 1 && (current = currentSelection.get(0)) instanceof IAdaptable) {
                EObject eobject = (EObject)((IAdaptable)current).getAdapter(EObject.class);
                if (eobject instanceof PapyrusTableInstance) {
                    this.oldPapyrusTableInstance.add((PapyrusTableInstance)eobject);
                }
                this.setBaseEnabled(this.oldPapyrusTableInstance != null && this.oldPapyrusTableInstance.size() == 1);
                return;
            }
        }
        this.setBaseEnabled(false);
    }
}

