/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.vsl.scoping.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.marte.vsl.extensions.VSLContextUtil;
import org.eclipse.papyrus.marte.vsl.scoping.visitors.Visitor;
import org.eclipse.papyrus.marte.vsl.validation.VSLJavaValidator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class ScopingVisitors {
    private static ScopingVisitors eInstance;
    public static final Visitor<Namespace, Namespace> importedNamespaces;
    public static final Visitor<Namespace, Namespace> ownedAndImportedNamespaces;
    public static final Visitor<Element, Namespace> ownedAndImportedProperties;
    public static final Visitor<Element, Namespace> ownedAndImportedBehaviors;
    public static final Visitor<Element, Namespace> ownedAndImportedEnumerationLiterals;
    public static final Visitor<Element, Namespace> ownedAndImportedInstantObservations;
    public static final Visitor<Element, Namespace> ownedAndImportedDurationObservations;
    public static final Visitor<Element, Namespace> ownedAndImportedDataTypes;
    public static final Visitor<List<Element>, Classifier> ownedOrInheritedAttributes;
    public static final Visitor<List<Element>, Classifier> ownedOrInheritedTupleAttributes;
    public static final Visitor<List<Element>, Classifier> ownedOrInheritedOperations;
    public static final Visitor<List<Element>, Element> hierarchichallyAccessibleProperties;
    public static final Visitor<List<Element>, Element> hierarchichallyAccessibleBehaviors;
    public static final Visitor<List<Element>, Element> hierarchichallyAccessibleInstantObservations;
    public static final Visitor<List<Element>, Element> hierarchichallyAccessibleDurationObservations;
    public static final Visitor<List<Element>, Element> hierarchichallyAccessibleDataTypes;
    public static final Visitor<Element, Namespace> recursivelyownedAndImportedInstantObservations;
    public static final Visitor<Element, Namespace> recursivelyownedAndImportedDurationObservations;

    static {
        ScopingVisitors scopingVisitors = eInstance = new ScopingVisitors();
        scopingVisitors.getClass();
        importedNamespaces = scopingVisitors.new Visitor_GetImportedNamespaces();
        ScopingVisitors scopingVisitors2 = eInstance;
        scopingVisitors2.getClass();
        ownedAndImportedNamespaces = scopingVisitors2.new Visitor_GetOwnedNamespacesAndImportedNamespaces();
        ScopingVisitors scopingVisitors3 = eInstance;
        scopingVisitors3.getClass();
        ownedAndImportedProperties = scopingVisitors3.new Visitor_GetOwnedAndImportedProperties();
        ScopingVisitors scopingVisitors4 = eInstance;
        scopingVisitors4.getClass();
        ownedAndImportedBehaviors = scopingVisitors4.new Visitor_GetOwnedAndImportedBehaviors();
        ScopingVisitors scopingVisitors5 = eInstance;
        scopingVisitors5.getClass();
        ownedAndImportedEnumerationLiterals = scopingVisitors5.new Visitor_GetOwnedAndImportedEnumerationLiterals();
        ScopingVisitors scopingVisitors6 = eInstance;
        scopingVisitors6.getClass();
        ownedAndImportedInstantObservations = scopingVisitors6.new Visitor_GetOwnedAndImportedInstantObservations();
        ScopingVisitors scopingVisitors7 = eInstance;
        scopingVisitors7.getClass();
        ownedAndImportedDurationObservations = scopingVisitors7.new Visitor_GetOwnedAndImportedDurationObservations();
        ScopingVisitors scopingVisitors8 = eInstance;
        scopingVisitors8.getClass();
        ownedAndImportedDataTypes = scopingVisitors8.new Visitor_GetOwnedAndImportedDataTypes();
        ScopingVisitors scopingVisitors9 = eInstance;
        scopingVisitors9.getClass();
        ownedOrInheritedAttributes = scopingVisitors9.new Visitor_GetOwnedOrInheritedAttributes();
        ScopingVisitors scopingVisitors10 = eInstance;
        scopingVisitors10.getClass();
        ownedOrInheritedTupleAttributes = scopingVisitors10.new Visitor_GetOwnedOrInheritedTupleAttributes();
        ScopingVisitors scopingVisitors11 = eInstance;
        scopingVisitors11.getClass();
        ownedOrInheritedOperations = scopingVisitors11.new Visitor_GetOwnedOrInheritedOperations();
        ScopingVisitors scopingVisitors12 = eInstance;
        scopingVisitors12.getClass();
        hierarchichallyAccessibleProperties = scopingVisitors12.new Visitor_GetHierarchichallyAccessibleProperties();
        ScopingVisitors scopingVisitors13 = eInstance;
        scopingVisitors13.getClass();
        hierarchichallyAccessibleBehaviors = scopingVisitors13.new Visitor_GetHierarchichallyAccessibleBehaviors();
        ScopingVisitors scopingVisitors14 = eInstance;
        scopingVisitors14.getClass();
        hierarchichallyAccessibleInstantObservations = scopingVisitors14.new Visitor_GetHierarchichallyAccessibleInstantObservations();
        ScopingVisitors scopingVisitors15 = eInstance;
        scopingVisitors15.getClass();
        hierarchichallyAccessibleDurationObservations = scopingVisitors15.new Visitor_GetHierarchichallyAccessibleDurationObservations();
        ScopingVisitors scopingVisitors16 = eInstance;
        scopingVisitors16.getClass();
        hierarchichallyAccessibleDataTypes = scopingVisitors16.new Visitor_GetHierarchichallyAccessibleDataTypes();
        ScopingVisitors scopingVisitors17 = eInstance;
        scopingVisitors17.getClass();
        recursivelyownedAndImportedInstantObservations = scopingVisitors17.new Visitor_getRecursivelyOwnedAndImportedInstantObservations();
        ScopingVisitors scopingVisitors18 = eInstance;
        scopingVisitors18.getClass();
        recursivelyownedAndImportedDurationObservations = scopingVisitors18.new Visitor_getRecursivelyOwnedAndImportedDurationObservations();
    }

    private static List<Element> getRecursivelyOwnedStereotypeInstances(Namespace context, Stereotype appliedStereotype) {
        ArrayList<Element> recursivelyOwnedStereotypeInstances = new ArrayList<Element>();
        EList allOwnedElements = context.getOwnedElements();
        for (Element e : allOwnedElements) {
            if (e.getStereotypeApplication(appliedStereotype) != null) {
                recursivelyOwnedStereotypeInstances.add(e);
            }
            if (!(e instanceof Namespace)) continue;
            recursivelyOwnedStereotypeInstances.addAll(ScopingVisitors.getRecursivelyOwnedStereotypeInstances((Namespace)e, appliedStereotype));
        }
        return recursivelyOwnedStereotypeInstances;
    }

    private static List<Element> getRecursivelyImportedStereotypeInstances(Namespace context, Stereotype appliedStereotype) {
        ArrayList<Element> recursivelyImportedStereotypeInstances = new ArrayList<Element>();
        EList importedPackages = context.getImportedPackages();
        for (Package p : importedPackages) {
            recursivelyImportedStereotypeInstances.addAll(ScopingVisitors.getRecursivelyOwnedStereotypeInstances((Namespace)p, appliedStereotype));
        }
        return recursivelyImportedStereotypeInstances;
    }

    private static List<Element> getRecursivelyOwnedMetaclassInstances(Namespace context, Class metaclass) {
        ArrayList<Element> recursivelyOwnedMetaclassInstances = new ArrayList<Element>();
        EList allOwnedElements = context.getOwnedElements();
        if (metaclass == null) {
            return recursivelyOwnedMetaclassInstances;
        }
        EClass namedElementEClass = UMLPackage.eINSTANCE.getNamedElement();
        EClassifier expectedEClass = UMLPackage.eINSTANCE.getEClassifier(metaclass.getName());
        if (expectedEClass == null) {
            return recursivelyOwnedMetaclassInstances;
        }
        for (Element n : context.getOwnedElements()) {
            if (expectedEClass.isInstance((Object)n)) {
                recursivelyOwnedMetaclassInstances.add(n);
            }
            if (!(n instanceof Namespace)) continue;
            recursivelyOwnedMetaclassInstances.addAll(ScopingVisitors.getRecursivelyOwnedMetaclassInstances((Namespace)n, metaclass));
        }
        return recursivelyOwnedMetaclassInstances;
    }

    private static List<Element> getRecursivelyOwnedMetaclassInstances(Namespace context, EClass expectedEClass) {
        ArrayList<Element> recursivelyOwnedMetaclassInstances = new ArrayList<Element>();
        if (expectedEClass == null) {
            return recursivelyOwnedMetaclassInstances;
        }
        for (Element n : context.getOwnedElements()) {
            if (expectedEClass.isInstance((Object)n)) {
                recursivelyOwnedMetaclassInstances.add(n);
            }
            if (!(n instanceof Namespace)) continue;
            recursivelyOwnedMetaclassInstances.addAll(ScopingVisitors.getRecursivelyOwnedMetaclassInstances((Namespace)n, expectedEClass));
        }
        return recursivelyOwnedMetaclassInstances;
    }

    private static List<Element> getRecursivelyImportedMetaclassInstances(Namespace context, Class metaclass) {
        ArrayList<Element> recursivelyImportedMetaclassInstances = new ArrayList<Element>();
        EList importedPackages = context.getImportedPackages();
        for (Package p : importedPackages) {
            recursivelyImportedMetaclassInstances.addAll(ScopingVisitors.getRecursivelyOwnedMetaclassInstances((Namespace)p, metaclass));
        }
        return recursivelyImportedMetaclassInstances;
    }

    private static List<Element> getRecursivelyImportedMetaclassInstances(Namespace context, EClass metaclass) {
        ArrayList<Element> recursivelyImportedMetaclassInstances = new ArrayList<Element>();
        EList importedPackages = context.getImportedPackages();
        for (Package p : importedPackages) {
            recursivelyImportedMetaclassInstances.addAll(ScopingVisitors.getRecursivelyOwnedMetaclassInstances((Namespace)p, metaclass));
        }
        return recursivelyImportedMetaclassInstances;
    }

    private class Visitor_GetHierarchichallyAccessibleBehaviors
    extends Visitor_GetHierarchichallyAccessibleElements {
        VSLContextUtil.MetaclassFilter filter;

        private Visitor_GetHierarchichallyAccessibleBehaviors() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getBehavior());
        }

        @Override
        protected List<Element> nestedVisit(Element context) {
            ArrayList<Element> accessibleBehaviors = new ArrayList<Element>();
            for (Element e : context.getOwnedElements()) {
                if (!this.filter.isInstance((EObject)e)) continue;
                accessibleBehaviors.add(e);
            }
            return accessibleBehaviors;
        }
    }

    private class Visitor_GetHierarchichallyAccessibleDataTypes
    extends Visitor_GetHierarchichallyAccessibleElements {
        VSLContextUtil.MetaclassFilter filter;

        private Visitor_GetHierarchichallyAccessibleDataTypes() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getDataType());
        }

        @Override
        protected List<Element> nestedVisit(Element context) {
            ArrayList<Element> accessibleDataTypes = new ArrayList<Element>();
            for (Element e : context.getOwnedElements()) {
                if (!this.filter.isInstance((EObject)e)) continue;
                accessibleDataTypes.add(e);
            }
            return accessibleDataTypes;
        }
    }

    private class Visitor_GetHierarchichallyAccessibleDurationObservations
    extends Visitor_GetHierarchichallyAccessibleElements {
        VSLContextUtil.MetaclassFilter filter;

        private Visitor_GetHierarchichallyAccessibleDurationObservations() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getDurationObservation());
        }

        @Override
        protected List<Element> nestedVisit(Element context) {
            ArrayList<Element> accessibleDurationObservations = new ArrayList<Element>();
            for (Element e : context.getOwnedElements()) {
                if (!this.filter.isInstance((EObject)e)) continue;
                accessibleDurationObservations.add(e);
            }
            return accessibleDurationObservations;
        }
    }

    private abstract class Visitor_GetHierarchichallyAccessibleElements
    implements Visitor<List<Element>, Element> {
        private Visitor_GetHierarchichallyAccessibleElements() {
        }

        protected abstract List<Element> nestedVisit(Element var1);

        @Override
        public List<List<Element>> visit(Element visited) {
            ArrayList<List<Element>> accessibleElements = new ArrayList<List<Element>>();
            ArrayList<Element> contextHierarchy = new ArrayList<Element>();
            contextHierarchy.add(visited);
            Element tmpContext = visited.getOwner();
            while (tmpContext != null) {
                contextHierarchy.add(0, tmpContext);
                tmpContext = tmpContext.getOwner();
            }
            for (Element currentContext : contextHierarchy) {
                ArrayList<Element> elements = new ArrayList<Element>();
                elements.addAll(this.nestedVisit(currentContext));
                accessibleElements.add(elements);
            }
            return accessibleElements;
        }
    }

    private class Visitor_GetHierarchichallyAccessibleInstantObservations
    extends Visitor_GetHierarchichallyAccessibleElements {
        VSLContextUtil.MetaclassFilter filter;

        private Visitor_GetHierarchichallyAccessibleInstantObservations() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getTimeObservation());
        }

        @Override
        protected List<Element> nestedVisit(Element context) {
            ArrayList<Element> accessibleInstantObservation = new ArrayList<Element>();
            for (Element e : context.getOwnedElements()) {
                if (!this.filter.isInstance((EObject)e)) continue;
                accessibleInstantObservation.add(e);
            }
            return accessibleInstantObservation;
        }
    }

    private class Visitor_GetHierarchichallyAccessibleProperties
    extends Visitor_GetHierarchichallyAccessibleElements {
        VSLContextUtil.MetaclassFilter filter;

        private Visitor_GetHierarchichallyAccessibleProperties() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getProperty());
        }

        @Override
        protected List<Element> nestedVisit(Element context) {
            ArrayList<Element> accessibleProperties = new ArrayList<Element>();
            for (Element e : context.getOwnedElements()) {
                if (!this.filter.isInstance((EObject)e)) continue;
                accessibleProperties.add(e);
            }
            return accessibleProperties;
        }
    }

    private class Visitor_GetImportedNamespaces
    implements Visitor<Namespace, Namespace> {
        protected VSLContextUtil.MetaclassFilter filter;

        private Visitor_GetImportedNamespaces() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getNamespace());
        }

        @Override
        public List<Namespace> visit(Namespace visited) {
            ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
            for (PackageImport pImport : visited.getPackageImports()) {
                namespaces.add((Namespace)pImport.getImportedPackage());
            }
            for (ElementImport eImport : visited.getElementImports()) {
                if (!this.filter.isInstance((EObject)eImport.getImportedElement())) continue;
                namespaces.add((Namespace)eImport.getImportedElement());
            }
            return namespaces;
        }

        /* synthetic */ Visitor_GetImportedNamespaces(Visitor_GetImportedNamespaces visitor_GetImportedNamespaces, Visitor_GetImportedNamespaces visitor_GetImportedNamespaces2) {
            this();
        }
    }

    private class Visitor_GetOwnedAndImportedBehaviors
    extends Visitor_GetOwnedAndImportedElements {
        private Visitor_GetOwnedAndImportedBehaviors() {
        }

        @Override
        protected void instantiateFilter() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getBehavior());
        }
    }

    private class Visitor_GetOwnedAndImportedDataTypes
    extends Visitor_GetOwnedAndImportedElements {
        private Visitor_GetOwnedAndImportedDataTypes() {
        }

        @Override
        protected void instantiateFilter() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getDataType());
        }
    }

    private class Visitor_GetOwnedAndImportedDurationObservations
    extends Visitor_GetOwnedAndImportedElements {
        private Visitor_GetOwnedAndImportedDurationObservations() {
        }

        @Override
        protected void instantiateFilter() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getDurationObservation());
        }

        /* synthetic */ Visitor_GetOwnedAndImportedDurationObservations(Visitor_GetOwnedAndImportedDurationObservations visitor_GetOwnedAndImportedDurationObservations, Visitor_GetOwnedAndImportedDurationObservations visitor_GetOwnedAndImportedDurationObservations2) {
            this();
        }
    }

    private abstract class Visitor_GetOwnedAndImportedElements
    implements Visitor<Element, Namespace> {
        protected VSLContextUtil.MetaclassFilter filter = null;

        private Visitor_GetOwnedAndImportedElements() {
        }

        protected abstract void instantiateFilter();

        @Override
        public List<Element> visit(Namespace visited) {
            this.instantiateFilter();
            ArrayList<Element> visibleElements = new ArrayList<Element>();
            for (ElementImport eImport : visited.getElementImports()) {
                if (!this.filter.isInstance((EObject)eImport.getImportedElement())) continue;
                visibleElements.add((Element)eImport.getImportedElement());
            }
            for (NamedElement n : visited.getOwnedMembers()) {
                if (!this.filter.isInstance((EObject)n)) continue;
                visibleElements.add((Element)n);
            }
            return visibleElements;
        }
    }

    private class Visitor_GetOwnedAndImportedEnumerationLiterals
    extends Visitor_GetOwnedAndImportedElements {
        private Visitor_GetOwnedAndImportedEnumerationLiterals() {
        }

        @Override
        protected void instantiateFilter() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getEnumerationLiteral());
        }
    }

    private class Visitor_GetOwnedAndImportedInstantObservations
    extends Visitor_GetOwnedAndImportedElements {
        private Visitor_GetOwnedAndImportedInstantObservations() {
        }

        @Override
        protected void instantiateFilter() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getTimeObservation());
        }

        /* synthetic */ Visitor_GetOwnedAndImportedInstantObservations(Visitor_GetOwnedAndImportedInstantObservations visitor_GetOwnedAndImportedInstantObservations, Visitor_GetOwnedAndImportedInstantObservations visitor_GetOwnedAndImportedInstantObservations2) {
            this();
        }
    }

    public static class Visitor_GetOwnedAndImportedMetaclassInstances {
        public static List<Element> visit(Namespace visited, Class expectedMetaclass) {
            ArrayList<Element> visibleElements = new ArrayList<Element>();
            if (expectedMetaclass == null) {
                return visibleElements;
            }
            EClass namedElementEClass = UMLPackage.eINSTANCE.getNamedElement();
            EClassifier expectedEClass = UMLPackage.eINSTANCE.getEClassifier(expectedMetaclass.getName());
            if (expectedEClass == null) {
                return visibleElements;
            }
            for (ElementImport eImport : visited.getElementImports()) {
                if (!expectedEClass.isInstance((Object)eImport.getImportedElement()) || !namedElementEClass.isInstance((Object)eImport.getImportedElement())) continue;
                visibleElements.add((Element)eImport.getImportedElement());
            }
            for (NamedElement n : visited.getOwnedMembers()) {
                if (!expectedEClass.isInstance((Object)n)) continue;
                visibleElements.add((Element)n);
            }
            return visibleElements;
        }
    }

    private class Visitor_GetOwnedAndImportedProperties
    extends Visitor_GetOwnedAndImportedElements {
        private Visitor_GetOwnedAndImportedProperties() {
        }

        @Override
        protected void instantiateFilter() {
            VSLContextUtil vSLContextUtil = VSLContextUtil.eInstance;
            vSLContextUtil.getClass();
            this.filter = vSLContextUtil.new VSLContextUtil.MetaclassFilter(UMLPackage.eINSTANCE.getProperty());
        }
    }

    public static class Visitor_GetOwnedAndImportedStereotypeInstances {
        public static List<Element> visit(Namespace visited, Stereotype appliedStereotype) {
            ArrayList<Element> visibleElements = new ArrayList<Element>();
            if (appliedStereotype == null) {
                return visibleElements;
            }
            for (ElementImport eImport : visited.getElementImports()) {
                if (eImport.getImportedElement().getStereotypeApplication(appliedStereotype) == null) continue;
                visibleElements.add((Element)eImport.getImportedElement());
            }
            for (NamedElement n : visited.getOwnedMembers()) {
                if (n.getStereotypeApplication(appliedStereotype) == null) continue;
                visibleElements.add((Element)n);
            }
            return visibleElements;
        }
    }

    private abstract class Visitor_GetOwnedAndInheritedElements
    implements Visitor<List<Element>, Classifier> {
        protected Classifier visited;

        private Visitor_GetOwnedAndInheritedElements() {
        }

        protected abstract List<Element> nestedVisit(Classifier var1);

        @Override
        public List<List<Element>> visit(Classifier visited) {
            this.visited = visited;
            ArrayList<List<Element>> allAttributes = new ArrayList<List<Element>>();
            ArrayList inheritanceStructure = new ArrayList();
            ArrayList<Object> tmpList = new ArrayList<Object>();
            tmpList.add(visited);
            do {
                inheritanceStructure.add(0, tmpList);
                ArrayList<Classifier> arrayList = new ArrayList<Classifier>();
                for (Classifier classifier : tmpList) {
                    for (Generalization generalization : classifier.getGeneralizations()) {
                        arrayList.add(generalization.getGeneral());
                    }
                }
                tmpList = new ArrayList();
                tmpList.addAll(arrayList);
            } while (!tmpList.isEmpty());
            if (!inheritanceStructure.isEmpty()) {
                for (List list : inheritanceStructure) {
                    ArrayList<Element> visibleElements = new ArrayList<Element>();
                    for (Classifier currentClassifier : list) {
                        visibleElements.addAll(this.nestedVisit(currentClassifier));
                    }
                    allAttributes.add(visibleElements);
                }
            }
            return allAttributes;
        }
    }

    private class Visitor_GetOwnedNamespacesAndImportedNamespaces
    extends Visitor_GetImportedNamespaces
    implements Visitor<Namespace, Namespace> {
        private Visitor_GetOwnedNamespacesAndImportedNamespaces() {
            super(null, null);
        }

        @Override
        public List<Namespace> visit(Namespace visited) {
            ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
            namespaces.addAll(super.visit(visited));
            for (NamedElement n : visited.getOwnedMembers()) {
                if (!this.filter.isInstance((EObject)n)) continue;
                namespaces.add((Namespace)n);
            }
            return namespaces;
        }
    }

    private class Visitor_GetOwnedOrInheritedAttributes
    extends Visitor_GetOwnedAndInheritedElements {
        private Visitor_GetOwnedOrInheritedAttributes() {
        }

        @Override
        protected List<Element> nestedVisit(Classifier visited) {
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.addAll((Collection<Element>)visited.getAttributes());
            return elements;
        }

        /* synthetic */ Visitor_GetOwnedOrInheritedAttributes(Visitor_GetOwnedOrInheritedAttributes visitor_GetOwnedOrInheritedAttributes, Visitor_GetOwnedOrInheritedAttributes visitor_GetOwnedOrInheritedAttributes2) {
            this();
        }
    }

    private class Visitor_GetOwnedOrInheritedOperations
    extends Visitor_GetOwnedAndInheritedElements {
        private Visitor_GetOwnedOrInheritedOperations() {
        }

        @Override
        protected List<Element> nestedVisit(Classifier visited) {
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.addAll((Collection<Element>)visited.getOperations());
            return elements;
        }
    }

    private class Visitor_GetOwnedOrInheritedTupleAttributes
    extends Visitor_GetOwnedOrInheritedAttributes {
        private Visitor_GetOwnedOrInheritedTupleAttributes() {
            super(null, null);
        }

        @Override
        protected List<Element> nestedVisit(Classifier visited) {
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.addAll(VSLContextUtil.getTupleAttribs(visited));
            return elements;
        }

        @Override
        public List<List<Element>> visit(Classifier visited) {
            ArrayList<List<Element>> tupleProperties = new ArrayList<List<Element>>();
            if (VSLContextUtil.isATupleType(visited)) {
                tupleProperties.addAll(super.visit(visited));
            }
            return tupleProperties;
        }
    }

    public static class Visitor_GetRecursivelyOwnedAndImportedMetaclassInstances {
        public static List<Element> visit(Namespace visited, Class metaclass) {
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.addAll(ScopingVisitors.getRecursivelyOwnedMetaclassInstances(VSLJavaValidator.getModel(), metaclass));
            elements.addAll(ScopingVisitors.getRecursivelyImportedMetaclassInstances(VSLJavaValidator.getModel(), metaclass));
            return elements;
        }

        public static List<Element> visit(Namespace visited, EClass metaclass) {
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.addAll(ScopingVisitors.getRecursivelyOwnedMetaclassInstances(VSLJavaValidator.getModel(), metaclass));
            elements.addAll(ScopingVisitors.getRecursivelyImportedMetaclassInstances(VSLJavaValidator.getModel(), metaclass));
            return elements;
        }
    }

    public static class Visitor_GetRecursivelyOwnedAndImportedStereotypeInstances {
        public static List<Element> visit(Namespace visited, Stereotype appliedStereotype) {
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.addAll(ScopingVisitors.getRecursivelyOwnedStereotypeInstances(VSLJavaValidator.getModel(), appliedStereotype));
            elements.addAll(ScopingVisitors.getRecursivelyImportedStereotypeInstances(VSLJavaValidator.getModel(), appliedStereotype));
            return elements;
        }
    }

    private class Visitor_getRecursivelyOwnedAndImportedDurationObservations
    extends Visitor_GetOwnedAndImportedDurationObservations {
        private Visitor_getRecursivelyOwnedAndImportedDurationObservations() {
            super(null, null);
        }

        @Override
        public List<Element> visit(Namespace visited) {
            if (this.filter == null) {
                this.instantiateFilter();
            }
            ArrayList<Element> allDurationObservations = new ArrayList<Element>();
            EList allOwnedElements = visited.allOwnedElements();
            for (Element e : allOwnedElements) {
                if (!this.filter.isInstance((EObject)e)) continue;
                allDurationObservations.add(e);
            }
            for (Package p : visited.getImportedPackages()) {
                allDurationObservations.addAll(super.visit((Namespace)p));
            }
            return allDurationObservations;
        }
    }

    private class Visitor_getRecursivelyOwnedAndImportedInstantObservations
    extends Visitor_GetOwnedAndImportedInstantObservations {
        private Visitor_getRecursivelyOwnedAndImportedInstantObservations() {
            super(null, null);
        }

        @Override
        public List<Element> visit(Namespace visited) {
            if (this.filter == null) {
                this.instantiateFilter();
            }
            ArrayList<Element> allInstantObservations = new ArrayList<Element>();
            EList allOwnedElements = visited.allOwnedElements();
            for (Element e : allOwnedElements) {
                if (!this.filter.isInstance((EObject)e)) continue;
                allInstantObservations.add(e);
            }
            for (Package p : visited.getImportedPackages()) {
                allInstantObservations.addAll(super.visit((Namespace)p));
            }
            return allInstantObservations;
        }
    }
}

