/*****************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 *    
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Sara TUCCI (CEA LIST) sara.tucci@cea.fr - Initial API and implementation
 *  Chokri MRAIDHA (CEA LIST) chokri.mraidha@cea.fr - Initial API and implementation
 *  David SERVAT (CEA LIST) david.servat@cea.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.eastadl.infrastructure.datatypes;



/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Rangeable Datatype</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The stereotype RangeableDatatype reflects numeric datatypes that may have a range (between a minimal and a maximal value). An example for a RangeableDatatype is the Celsius temperature scale with minValue = -273.15.
 * 
 * Semantics:
 * The stereotype RangeableDatatype reflects numeric datatypes that may have a range (between a minimal and a maximal value).
 * 
 * 
 * Extension: UML Datatype
 * <!-- end-model-doc -->
 *
 *
 * @see org.eclipse.papyrus.eastadl.infrastructure.datatypes.DatatypesPackage#getRangeableDatatype()
 * @model abstract="true"
 * @generated
 */
public interface RangeableDatatype extends EADatatype {

} // RangeableDatatype
