/**
 * Copyright (c) 2015 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Florian Noyrit - Initial API and implementation
 */
package aspects.xpt;

import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.xtend2.lib.StringConcatenation;

@Singleton
@SuppressWarnings("all")
public class QualifiedClassNameProvider extends xpt.QualifiedClassNameProvider {
  @Override
  protected CharSequence _getItemSemanticEditPolicyQualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCompartmentSemanticEditPolicy");
    return _builder;
  }
  
  @Override
  protected CharSequence _getItemSemanticEditPolicyQualifiedClassName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCompartmentSemanticEditPolicy");
    return _builder;
  }
  
  @Override
  protected CharSequence _getItemSemanticEditPolicyQualifiedClassName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy");
    return _builder;
  }
  
  @Override
  protected CharSequence _getItemSemanticEditPolicyQualifiedClassName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy");
    return _builder;
  }
  
  @Override
  public CharSequence getItemSemanticEditPolicyQualifiedClassName(final GenCommonBase it) {
    if (it instanceof GenCompartment) {
      return _getItemSemanticEditPolicyQualifiedClassName((GenCompartment)it);
    } else if (it instanceof GenNode) {
      return _getItemSemanticEditPolicyQualifiedClassName((GenNode)it);
    } else if (it instanceof GenDiagram) {
      return _getItemSemanticEditPolicyQualifiedClassName((GenDiagram)it);
    } else if (it instanceof GenLink) {
      return _getItemSemanticEditPolicyQualifiedClassName((GenLink)it);
    } else if (it != null) {
      return _getItemSemanticEditPolicyQualifiedClassName(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
