/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.ui.util.UIUtil;
import org.eclipse.papyrus.uml.profile.types.generator.AbstractGenerator;
import org.eclipse.papyrus.uml.profile.types.generator.ElementTypesGenerator;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ui.internal.Activator;
import org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards.GeneratorMainPage;
import org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards.GeneratorWizardModel;
import org.eclipse.papyrus.uml.profile.types.generator.ui.internal.wizards.IGeneratorWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Profile;

public class GeneratorWizard
extends Wizard {
    private static final String ELEMENTTYPESCONFIGURATIONS = "elementtypesconfigurations";
    private final IWorkbenchPage page;
    private final GeneratorWizardModel model;

    public GeneratorWizard(IWorkbenchPage page, Profile profile) {
        this.setDialogSettings(DialogSettings.getOrCreateSection((IDialogSettings)Activator.getInstance().getDialogSettings(), (String)GeneratorWizard.class.getName()));
        this.page = page;
        this.model = new GeneratorWizardModel((IWizard)this, profile, this.getDialogSettings());
        this.setWindowTitle("Generate Element Types Model");
        this.setHelpAvailable(false);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.addPage(this.createMainPage(this.model));
    }

    protected IGeneratorWizardPage createMainPage(GeneratorWizardModel model) {
        return new GeneratorMainPage(model, "Element Types Configuration Model", "Enter details of the element types model to generate.", ELEMENTTYPESCONFIGURATIONS);
    }

    private void save() {
        for (IGeneratorWizardPage next : Iterables.filter(Arrays.asList(this.getPages()), IGeneratorWizardPage.class)) {
            next.save();
        }
    }

    public boolean performFinish() {
        this.save();
        final IStatus[] status = new IStatus[]{Status.CANCEL_STATUS};
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    status[0] = GeneratorWizard.this.doPerformFinish(monitor);
                }
            });
        }
        catch (InterruptedException e) {
            status[0] = Status.CANCEL_STATUS;
        }
        catch (InvocationTargetException e) {
            status[0] = new Status(4, "org.eclipse.papyrus.uml.profile.types.generator.ui", "Model generation failed with an exception.", e.getTargetException());
        }
        if (status[0].matches(6)) {
            StatusManager.getManager().handle(status[0], 5);
        }
        return status[0].getSeverity() < 4;
    }

    protected IStatus doPerformFinish(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        Identifiers identifiers = new Identifiers();
        if (this.model.isAddDiPostfixActive()) {
            identifiers.setPrefix(String.valueOf(this.model.getIdentifier()) + Identifiers.diPostfix());
            identifiers.setUseDiPostfix(true);
        } else {
            identifiers.setPrefix(this.model.getIdentifier());
        }
        identifiers.setBaseElementTypesSet(this.model.getSelectedElementTypeSet());
        identifiers.setSuppressSemanticSuperElementTypes(this.model.isSuppressSemanticSuperElementTypes());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        identifiers.setAdapterFactory((AdapterFactory)adapterFactory);
        try {
            ArrayList generators = Lists.newArrayListWithExpectedSize((int)1);
            this.addGenerators(generators, identifiers, this.model);
            monitor.beginTask(NLS.bind((String)"Generating {0}", (Object)(generators.size() > 1 ? "models" : "model")), generators.size() + 1);
            for (AbstractGenerator next : generators) {
                monitor.subTask(next.getLabel());
                result = next.generate((EObject)this.model.getProfile(), this.getOutputURI(next, identifiers, this.model));
                if (result.getSeverity() >= 4) break;
                monitor.worked(1);
            }
            if (result.getSeverity() < 4) {
                monitor.subTask("Opening editor");
                try {
                    Futures.getChecked((Future)UIUtil.syncCall((Display)this.getShell().getDisplay(), (Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            IDE.openEditor((IWorkbenchPage)GeneratorWizard.this.page, (IFile)GeneratorWizard.this.model.getOutputModelFile());
                            return null;
                        }
                    }), PartInitException.class);
                }
                catch (PartInitException e) {
                    result = e.getStatus();
                }
            }
        }
        finally {
            adapterFactory.dispose();
            monitor.done();
        }
        return result;
    }

    protected void addGenerators(List<? super AbstractGenerator<Profile, ?>> generators, Identifiers identifiers, GeneratorWizardModel wizardModel) {
        generators.add((AbstractGenerator<Profile, ?>)new ElementTypesGenerator(identifiers));
    }

    protected URI getOutputURI(AbstractGenerator<Profile, ?> generator, Identifiers identifiers, GeneratorWizardModel wizardModel) {
        return wizardModel.getOutputModelURI();
    }
}

