/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.xpand.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrus.gmf.internal.xpand.StreamsHolder;
import org.eclipse.papyrus.gmf.internal.xpand.model.EvaluationException;

public class XpandStreamsHolder
implements StreamsHolder {
    private HashMap<String, StringBuilder> myStreams;
    private HashSet<String> myStreamsAccessed;

    @Override
    public String getStreamContents(String slotName) {
        if (this.myStreams == null) {
            throw new EvaluationException("Undefined stream " + slotName);
        }
        StringBuilder result = this.myStreams.get(slotName);
        if (result == null) {
            throw new EvaluationException("Undefined stream " + slotName);
        }
        this.setAccessed(slotName);
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    @Override
    public List<String> getSlotNames() {
        if (this.myStreams == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(this.myStreams.size());
        for (Map.Entry<String, StringBuilder> next : this.myStreams.entrySet()) {
            if (next.getValue().length() == 0) continue;
            result.add(next.getKey());
        }
        return Collections.unmodifiableList(result);
    }

    public void addNamedStream(String name, StringBuilder stream) {
        if (this.myStreams == null) {
            this.myStreams = new HashMap();
        }
        assert (!this.myStreams.containsKey(name));
        this.myStreams.put(name, stream);
    }

    private void setAccessed(String slotName) {
        if (this.myStreamsAccessed == null) {
            this.myStreamsAccessed = new HashSet();
        }
        this.myStreamsAccessed.add(slotName);
    }

    public boolean isAccessed(String slotName) {
        return this.myStreamsAccessed != null && this.myStreamsAccessed.contains(slotName);
    }
}

