/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.architectureview.providers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.papyrus.architectureview.Activator;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureDomainItemProvider;
import org.eclipse.papyrus.infra.core.architecture.provider.ArchitectureItemProviderAdapterFactory;
import org.eclipse.swt.graphics.Image;

public class ArchiectureViewLabelProvider
implements ITableLabelProvider {
    private Map<Resource, Integer> diagnosticByArchitecture = new HashMap<Resource, Integer>();
    private Map<Resource, Boolean> mergedArchitecture = new HashMap<Resource, Boolean>();

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
        this.mergedArchitecture.clear();
        this.mergedArchitecture = null;
        this.diagnosticByArchitecture.clear();
        this.diagnosticByArchitecture = null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Resource) {
            Resource architectureResource = (Resource)element;
            ArchitectureDomain architectureDomain = null;
            EObject rootContent = (EObject)architectureResource.getContents().get(0);
            if (rootContent instanceof ArchitectureDomain) {
                architectureDomain = (ArchitectureDomain)rootContent;
            }
            switch (columnIndex) {
                case 0: {
                    return architectureDomain != null ? architectureDomain.getName() : "Unknown name";
                }
                case 1: {
                    return architectureDomain != null ? architectureDomain.getId() : "Unknown identifier";
                }
                case 2: {
                    if (this.mergedArchitecture.get(architectureResource) != null) {
                        return this.mergedArchitecture.get(architectureResource).toString();
                    }
                    if (architectureDomain == null) {
                        this.mergedArchitecture.put(architectureResource, false);
                    } else {
                        String architectureDomainName = architectureDomain.getName();
                        Collection visibleArchitectureContexts = ArchitectureDomainManager.getInstance().getVisibleArchitectureContexts();
                        this.mergedArchitecture.put(architectureResource, visibleArchitectureContexts.stream().filter(ac -> ac.getParent().getName().equals(architectureDomainName) && ac.getParent().getElementsNumber() > 1).findFirst().isPresent());
                    }
                    return this.mergedArchitecture.get(architectureResource).toString();
                }
                case 3: {
                    return architectureResource.getURI().lastSegment();
                }
                case 4: {
                    URI uri = architectureResource.getURI();
                    return uri.segmentCount() > 2 ? uri.segment(1) : uri.toString();
                }
                case 5: {
                    if (architectureDomain != null && this.diagnosticByArchitecture.get(architectureResource) == null) {
                        this.diagnosticByArchitecture.put(architectureResource, Diagnostician.INSTANCE.validate((EObject)architectureDomain).getSeverity());
                    }
                    return this.diagnosticByArchitecture.get(architectureResource) == 0 ? "true" : "false";
                }
            }
        } else if (element instanceof ADElement) {
            if (columnIndex == 0) {
                return ((ADElement)element).getName();
            }
            return "";
        }
        return "cannot display it: " + element;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ArchitectureDomain architectureDomain;
        EObject rootContent;
        if (columnIndex == 0) {
            ArchitectureItemProviderAdapterFactory adapterFactory = new ArchitectureItemProviderAdapterFactory();
            IItemLabelProvider itemProvider = null;
            if (element instanceof Resource) {
                EObject rootContent2 = (EObject)((Resource)element).getContents().get(0);
                if (rootContent2 instanceof ArchitectureDomain) {
                    ArchitectureDomain architectureDomain2 = (ArchitectureDomain)rootContent2;
                    itemProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)architectureDomain2, ArchitectureDomainItemProvider.class);
                }
            } else if (element instanceof ADElement) {
                itemProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)((ADElement)element), IItemLabelProvider.class);
            }
            if (itemProvider != null) {
                return ExtendedImageRegistry.getInstance().getImage(itemProvider.getImage(element));
            }
        }
        if (2 == columnIndex && element instanceof Resource) {
            if (this.mergedArchitecture.get(element) == null && (rootContent = (EObject)((Resource)element).getContents().get(0)) instanceof ArchitectureDomain) {
                architectureDomain = (ArchitectureDomain)rootContent;
                String architectureDomainName = architectureDomain.getName();
                Collection visibleArchitectureContexts = ArchitectureDomainManager.getInstance().getVisibleArchitectureContexts();
                this.mergedArchitecture.put((Resource)element, visibleArchitectureContexts.stream().filter(ac -> ac.getName().equals(architectureDomainName) && ac.getElementsNumber() > 1).findFirst().isPresent());
            }
            return this.mergedArchitecture.get(element) != false ? Activator.CHECKED_IMAGE : Activator.UNCHECKED_IMAGE;
        }
        if (5 == columnIndex && element instanceof Resource) {
            if (this.diagnosticByArchitecture.get(element) == null && (rootContent = (EObject)((Resource)element).getContents().get(0)) instanceof ArchitectureDomain) {
                architectureDomain = (ArchitectureDomain)rootContent;
                this.diagnosticByArchitecture.put((Resource)element, Diagnostician.INSTANCE.validate((EObject)architectureDomain).getSeverity());
            }
            return this.diagnosticByArchitecture.get(element) == 0 ? Activator.VALID_IMAGE : Activator.INVALID_IMAGE;
        }
        return null;
    }
}

