/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.genmodel;

import org.eclipse.papyrus.gmf.mappings.AuditContainer;
import org.eclipse.papyrus.gmf.mappings.CanvasMapping;
import org.eclipse.papyrus.gmf.mappings.LinkMapping;
import org.eclipse.papyrus.gmf.mappings.Mapping;
import org.eclipse.papyrus.gmf.mappings.MetricContainer;
import org.eclipse.papyrus.gmf.mappings.TopNodeReference;

public abstract class MappingTransformer {
    public void transform(Mapping m) {
        this.process(m.getDiagram());
        for (TopNodeReference element : m.getNodes()) {
            this.process(element);
        }
        for (TopNodeReference element : m.getLinks()) {
            this.process((LinkMapping)element);
        }
        this.process(m.getMetrics());
        this.process(m.getAudits());
        this.complete();
    }

    protected abstract void process(CanvasMapping var1);

    protected abstract void process(TopNodeReference var1);

    protected abstract void process(LinkMapping var1);

    protected abstract void process(AuditContainer var1);

    protected abstract void process(MetricContainer var1);

    protected void complete() {
    }
}

