/**
 * Copyright (c) 2013, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Michael Golubev (Montages) - initial API and implementation
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.papyrus.gmf.gmfgraph.CustomBorder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * FIXME: @Singleton is ugly way to workaround the absence of FILE directive and QVTO properties.
 * Fortunately, it is the only place across all GMFT templates where those 2 features had been used
 */
@Singleton
@SuppressWarnings("all")
public class Utils_Statefull_qvto {
  private List<CustomBorder> myBordersInUse;
  
  private List<CharSequence> myStaticFieldsStream;
  
  public void addBorder(final CustomBorder border) {
    this.myBordersInUse.add(border);
  }
  
  public void clearState() {
    this.myBordersInUse = CollectionLiterals.<CustomBorder>newLinkedList();
    this.myStaticFieldsStream = CollectionLiterals.<CharSequence>newLinkedList();
  }
  
  public Iterable<CustomBorder> getBordersInUse() {
    return this.myBordersInUse;
  }
  
  /**
   * XXX [MG]: workaround for «FILE» directive is not supported in Xtend2
   */
  public void addToStaticStream(final CharSequence code) {
    if (((!Objects.equal(code, null)) && (code.length() > 0))) {
      this.myStaticFieldsStream.add(code);
    }
  }
  
  public Iterable<CharSequence> staticStream() {
    return this.myStaticFieldsStream;
  }
}
