/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph.top;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import gmfgraph.Utils_Statefull_qvto;
import gmfgraph.Utils_qvto;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.gmf.gmfgraph.ChildAccess;
import org.eclipse.papyrus.gmf.gmfgraph.CustomFigure;
import org.eclipse.papyrus.gmf.gmfgraph.FigureAccessor;
import org.eclipse.papyrus.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.papyrus.gmf.gmfgraph.RealFigure;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.Common;
import xpt.Common_qvto;

@Singleton
@SuppressWarnings("all")
public class Descriptor {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Common_qvto _common_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  @Extension
  private Utils_Statefull_qvto _utils_Statefull_qvto;
  
  @Inject
  private gmfgraph.Runtime xptRuntime;
  
  @Inject
  private Figure xptFigure;
  
  public CharSequence Top(final FigureDescriptor it, final String packageStmt) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(packageStmt);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        _builder.append("package ");
        _builder.append(packageStmt);
        _builder.append(";");
      }
    }
    _builder.newLineIfNotEmpty();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    String _compilationUnitName = this._utils_qvto.compilationUnitName(it);
    _builder.append(_compilationUnitName);
    _builder.append(" extends ");
    CharSequence _fqn = this.xptRuntime.fqn(it.getActualFigure());
    _builder.append(_fqn);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    CharSequence _body = this.body(it);
    _builder.append(_body);
    _builder.newLineIfNotEmpty();
    CharSequence _additionalStaticFields = this.additionalStaticFields();
    _builder.append(_additionalStaticFields);
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence Inner(final FigureDescriptor it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    String _compilationUnitName = this._utils_qvto.compilationUnitName(it);
    _builder.append(_compilationUnitName);
    _builder.append(" extends ");
    CharSequence _fqn = this.xptRuntime.fqn(it.getActualFigure());
    _builder.append(_fqn);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _body = this.body(it);
    _builder.append(_body, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    CharSequence _additionalStaticFields = this.additionalStaticFields();
    _builder.append(_additionalStaticFields);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence body(final FigureDescriptor it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    {
      final Function1<ChildAccess, Boolean> _function = new Function1<ChildAccess, Boolean>() {
        @Override
        public Boolean apply(final ChildAccess a) {
          final Function1<FigureAccessor, RealFigure> _function = new Function1<FigureAccessor, RealFigure>() {
            @Override
            public RealFigure apply(final FigureAccessor it) {
              return it.getTypedFigure();
            }
          };
          final Function1<RealFigure, Boolean> _function_1 = new Function1<RealFigure, Boolean>() {
            @Override
            public Boolean apply(final RealFigure f) {
              org.eclipse.papyrus.gmf.gmfgraph.Figure _figure = a.getFigure();
              return Boolean.valueOf(Objects.equal(f, _figure));
            }
          };
          boolean _exists = IterableExtensions.<RealFigure>exists(IterableExtensions.<FigureAccessor, RealFigure>map(Descriptor.this._utils_qvto.allCustomAccessors(it), _function), _function_1);
          return Boolean.valueOf((!_exists));
        }
      };
      Iterable<ChildAccess> _filter = IterableExtensions.<ChildAccess>filter(it.getAccessors(), _function);
      for(final ChildAccess acc : _filter) {
        CharSequence _accessorField = this.accessorField(acc);
        _builder.append(_accessorField);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    {
      Iterable<CustomFigure> _filterCustom = this._utils_qvto.filterCustom(CollectionLiterals.<org.eclipse.papyrus.gmf.gmfgraph.Figure>newLinkedList(it.getActualFigure()));
      for(final CustomFigure custom : _filterCustom) {
        {
          boolean _needsField = this._utils_qvto.needsField(custom);
          if (_needsField) {
            CharSequence _accessorCustomField = this.accessorCustomField(custom);
            _builder.append(_accessorCustomField);
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    CharSequence _ClassBody = this.xptFigure.ClassBody(it.getActualFigure(), this._utils_qvto.compilationUnitName(it));
    _builder.append(_ClassBody);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      final Function1<ChildAccess, Boolean> _function_1 = new Function1<ChildAccess, Boolean>() {
        @Override
        public Boolean apply(final ChildAccess a) {
          final Function1<FigureAccessor, RealFigure> _function = new Function1<FigureAccessor, RealFigure>() {
            @Override
            public RealFigure apply(final FigureAccessor it) {
              return it.getTypedFigure();
            }
          };
          final Function1<RealFigure, Boolean> _function_1 = new Function1<RealFigure, Boolean>() {
            @Override
            public Boolean apply(final RealFigure f) {
              org.eclipse.papyrus.gmf.gmfgraph.Figure _figure = a.getFigure();
              return Boolean.valueOf(Objects.equal(f, _figure));
            }
          };
          boolean _exists = IterableExtensions.<RealFigure>exists(IterableExtensions.<FigureAccessor, RealFigure>map(Descriptor.this._utils_qvto.allCustomAccessors(it), _function), _function_1);
          return Boolean.valueOf((!_exists));
        }
      };
      Iterable<ChildAccess> _filter_1 = IterableExtensions.<ChildAccess>filter(it.getAccessors(), _function_1);
      for(final ChildAccess acc_1 : _filter_1) {
        CharSequence _accessorToField = this.accessorToField(acc_1);
        _builder.append(_accessorToField);
        _builder.newLineIfNotEmpty();
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      final Function1<ChildAccess, Boolean> _function_2 = new Function1<ChildAccess, Boolean>() {
        @Override
        public Boolean apply(final ChildAccess a) {
          final Function1<FigureAccessor, RealFigure> _function = new Function1<FigureAccessor, RealFigure>() {
            @Override
            public RealFigure apply(final FigureAccessor it) {
              return it.getTypedFigure();
            }
          };
          final Function1<RealFigure, Boolean> _function_1 = new Function1<RealFigure, Boolean>() {
            @Override
            public Boolean apply(final RealFigure f) {
              org.eclipse.papyrus.gmf.gmfgraph.Figure _figure = a.getFigure();
              return Boolean.valueOf(Objects.equal(f, _figure));
            }
          };
          return Boolean.valueOf(IterableExtensions.<RealFigure>exists(IterableExtensions.<FigureAccessor, RealFigure>map(Descriptor.this._utils_qvto.allCustomAccessors(it), _function), _function_1));
        }
      };
      Iterable<ChildAccess> _filter_2 = IterableExtensions.<ChildAccess>filter(it.getAccessors(), _function_2);
      for(final ChildAccess acc_2 : _filter_2) {
        final Function1<FigureAccessor, Boolean> _function_3 = new Function1<FigureAccessor, Boolean>() {
          @Override
          public Boolean apply(final FigureAccessor fa) {
            RealFigure _typedFigure = fa.getTypedFigure();
            org.eclipse.papyrus.gmf.gmfgraph.Figure _figure = acc_2.getFigure();
            return Boolean.valueOf(Objects.equal(_typedFigure, _figure));
          }
        };
        CharSequence _accessorToCustom = this.accessorToCustom(acc_2, IterableExtensions.<FigureAccessor>filter(this._utils_qvto.allCustomAccessors(it), _function_3));
        _builder.append(_accessorToCustom);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence accessorField(final ChildAccess it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private ");
    CharSequence _fqn = this.xptRuntime.fqn(it.getFigure());
    _builder.append(_fqn);
    _builder.append(" ");
    String _figureFieldName = this._utils_qvto.figureFieldName(it);
    _builder.append(_figureFieldName);
    _builder.append("; ");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence accessorCustomField(final CustomFigure it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private ");
    CharSequence _fqn = this.xptRuntime.fqn(it);
    _builder.append(_fqn);
    _builder.append(" ");
    String _figureFieldName = this._utils_qvto.figureFieldName(it);
    _builder.append(_figureFieldName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * ChildAccess points to figure we've generated, here's a field for it
   */
  public CharSequence accessorToField(final ChildAccess it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _fqn = this.xptRuntime.fqn(it.getFigure());
    _builder.append(_fqn);
    _builder.append(" ");
    String _accessor = it.getAccessor();
    _builder.append(_accessor);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    String _figureFieldName = this._utils_qvto.figureFieldName(it);
    _builder.append(_figureFieldName, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  /**
   * ChildAccess points to some child of a CustomFigure, need to delegate to it's accessor.
   * Perhaps, should add support for ChildAccess not being generated (in case they are have same name as
   * FigureAccessor.accessor
   */
  public CharSequence accessorToCustom(final ChildAccess it, final Iterable<FigureAccessor> fa) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    CharSequence _fqn = this.xptRuntime.fqn(it.getFigure());
    _builder.append(_fqn);
    _builder.append(" ");
    String _accessor = it.getAccessor();
    _builder.append(_accessor);
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    final LinkedList<FigureAccessor> chain = this._utils_qvto.getCustomFigureChainFigureAccess(it);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    EObject _eContainer = chain.getFirst().eContainer();
    String _figureFieldName = this._utils_qvto.figureFieldName(((CustomFigure) _eContainer));
    _builder.append(_figureFieldName, "\t");
    _builder.newLineIfNotEmpty();
    {
      for(final FigureAccessor figureAccess : chain) {
        _builder.append("\t\t");
        {
          if (((!Objects.equal(figureAccess.getAccessor(), null)) && (!figureAccess.getAccessor().isEmpty()))) {
            _builder.append(".");
            String _accessor_1 = figureAccess.getAccessor();
            _builder.append(_accessor_1, "\t\t");
            _builder.append("()");
          } else {
            String _string = figureAccess.toString();
            String _plus = ("Invalide figure accessor " + _string);
            this._common_qvto.ERROR(_plus);
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additionalStaticFields() {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isEmpty = IterableExtensions.isEmpty(this._utils_Statefull_qvto.staticStream());
      boolean _not = (!_isEmpty);
      if (_not) {
        {
          Iterable<CharSequence> _staticStream = this._utils_Statefull_qvto.staticStream();
          for(final CharSequence str : _staticStream) {
            _builder.append(str);
            _builder.newLineIfNotEmpty();
          }
        }
      } else {
        CharSequence _extraLineBreak = this._common.extraLineBreak();
        _builder.append(_extraLineBreak);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
