/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.architectureview.views;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.architectureview.Activator;
import org.eclipse.papyrus.architectureview.providers.ArchiectureViewLabelProvider;
import org.eclipse.papyrus.architectureview.providers.ArchitectureViewContentProvider;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ArchitectureView
extends ViewPart {
    private TreeViewer viewer;
    private ResourceSet resourceSet;

    protected Tree createTree(Composite parent) {
        Tree tree = new Tree(parent, 66306);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        return tree;
    }

    protected TreeViewer getViewer() {
        return this.viewer;
    }

    protected void createColumns() {
        SelectionAdapter sortListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeColumn column = (TreeColumn)e.getSource();
                TreeColumn previousSortColumn = ArchitectureView.this.viewer.getTree().getSortColumn();
                int sortDirection = 1024;
                if (previousSortColumn != null) {
                    int prevSortDirection = ArchitectureView.this.viewer.getTree().getSortDirection();
                    if (column.equals(previousSortColumn)) {
                        sortDirection = prevSortDirection == 128 ? 1024 : 128;
                        ArchitectureView.this.viewer.getTree().setSortDirection(sortDirection);
                    } else {
                        ArchitectureView.this.viewer.getTree().setSortColumn(column);
                        ArchitectureView.this.viewer.getTree().setSortDirection(1024);
                    }
                } else {
                    ArchitectureView.this.viewer.getTree().setSortColumn(column);
                    ArchitectureView.this.viewer.getTree().setSortDirection(1024);
                }
                ArchitectureView.this.viewer.refresh();
            }
        };
        TreeColumn tcName = new TreeColumn(this.viewer.getTree(), 16384);
        tcName.setText("Name");
        tcName.setWidth(200);
        tcName.addSelectionListener((SelectionListener)sortListener);
        TreeColumn tcId = new TreeColumn(this.viewer.getTree(), 16384);
        tcId.setText("Identifier");
        tcId.setWidth(250);
        tcId.addSelectionListener((SelectionListener)sortListener);
        TreeColumn tcMerged = new TreeColumn(this.viewer.getTree(), 16384);
        tcMerged.setText("Merged");
        tcMerged.setWidth(100);
        tcMerged.addSelectionListener((SelectionListener)sortListener);
        TreeColumn tcFileName = new TreeColumn(this.viewer.getTree(), 16384);
        tcFileName.setText("File Name");
        tcFileName.setWidth(150);
        tcFileName.addSelectionListener((SelectionListener)sortListener);
        TreeColumn tcPlugin = new TreeColumn(this.viewer.getTree(), 16384);
        tcPlugin.setText("Plug-in");
        tcPlugin.setWidth(250);
        tcPlugin.addSelectionListener((SelectionListener)sortListener);
        TreeColumn tcIsValid = new TreeColumn(this.viewer.getTree(), 16384);
        tcIsValid.setText("IsValid");
        tcIsValid.setWidth(100);
        tcIsValid.addSelectionListener((SelectionListener)sortListener);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(this.createTree(parent));
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer treeViewer = (TreeViewer)viewer;
                TreeColumn column = treeViewer.getTree().getSortColumn();
                if (column == null) {
                    return super.compare(viewer, e1, e2);
                }
                int sortDirection = treeViewer.getTree().getSortDirection();
                int columnIndex = -1;
                int cpt = 0;
                while (cpt < treeViewer.getTree().getColumnCount() && -1 == columnIndex) {
                    if (treeViewer.getTree().getColumn(cpt).equals(column)) {
                        columnIndex = cpt;
                    }
                    ++cpt;
                }
                String firstValue = ((ITableLabelProvider)treeViewer.getLabelProvider()).getColumnText(e1, columnIndex);
                String secondValue = ((ITableLabelProvider)treeViewer.getLabelProvider()).getColumnText(e2, columnIndex);
                return 1024 == sortDirection ? this.getComparator().compare(firstValue, secondValue) : this.getComparator().compare(secondValue, firstValue);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    for (Object selectedObject : ((IStructuredSelection)selection).toList()) {
                        if (selectedObject instanceof Resource) {
                            try {
                                page.openEditor((IEditorInput)new URIEditorInput(((Resource)selectedObject).getURI()), "org.eclipse.papyrus.infra.ui.architecture.ArchitectureEditorID", true);
                            }
                            catch (PartInitException e) {
                                Activator.log.error("The selected resource cannot be opened.", (Throwable)e);
                            }
                            continue;
                        }
                        if (ArchitectureView.this.viewer.getExpandedState(selectedObject)) {
                            ArchitectureView.this.viewer.collapseToLevel(selectedObject, -1);
                            continue;
                        }
                        ArchitectureView.this.viewer.expandToLevel(selectedObject, 1);
                    }
                }
            }
        });
        this.createColumns();
        this.resourceSet = new ResourceSetImpl();
        Collection registeredArchitectureModels = ArchitectureDomainManager.getInstance().getRegisteredArchitectureModels();
        ArrayList<Resource> inputResources = new ArrayList<Resource>(registeredArchitectureModels.size());
        for (URI uri : registeredArchitectureModels) {
            Resource testResource = this.resourceSet.createResource(uri);
            try {
                testResource.load(null);
                inputResources.add(testResource);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.viewer.setInput(inputResources);
    }

    protected ITableLabelProvider getLabelProvider() {
        return new ArchiectureViewLabelProvider();
    }

    protected IContentProvider getContentProvider() {
        return new ArchitectureViewContentProvider();
    }

    public void setFocus() {
        TreeViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().setFocus();
        }
    }

    public void dispose() {
        this.resourceSet = null;
        super.dispose();
    }
}

