/**
 * Copyright (c) 2007, 2009 Borland Software Corporation
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Artem Tikhomirov (Borland) - [257119] Create views directly, not through ViewFactories
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 */
package aspects.xpt.diagram.views;

import aspects.xpt.Common;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import xpt.diagram.Utils_qvto;
import xpt.diagram.ViewmapAttributesUtils_qvto;

/**
 * Renamed from xpt::diagram::views::Utils.xpt
 * in order to have consistent naming between Xtend files migrated from _qvto helpers and xpt templates
 */
@Singleton
@SuppressWarnings("all")
public class ViewStyles extends xpt.diagram.views.ViewStyles {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private ViewmapAttributesUtils_qvto _viewmapAttributesUtils_qvto;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Override
  protected CharSequence _offset(final GenExternalNodeLabel it, final String viewVar) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((this._viewmapAttributesUtils_qvto.labelOffsetX(it.getViewmap(), 0) != 0) || (this._viewmapAttributesUtils_qvto.labelOffsetY(it.getViewmap(), 0) != 0))) {
        CharSequence _offset = this.offset(it, viewVar, this._viewmapAttributesUtils_qvto.labelOffsetX(it.getViewmap(), 0), this._viewmapAttributesUtils_qvto.labelOffsetY(it.getViewmap(), 0));
        _builder.append(_offset);
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _offset_1 = this.offset(it, viewVar, 0, 15);
        _builder.append(_offset_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence offset(final GenLabel it, final String viewVar, final int x, final int y) {
    StringConcatenation _builder = new StringConcatenation();
    String _firstLower = StringExtensions.toFirstLower(this._common.stringUniqueIdentifier(it));
    final String location = (_firstLower + "_Location");
    _builder.newLineIfNotEmpty();
    _builder.append("org.eclipse.gmf.runtime.notation.Location ");
    _builder.append(location);
    _builder.append(" = (org.eclipse.gmf.runtime.notation.Location) ");
    _builder.append(viewVar);
    _builder.append(".getLayoutConstraint();");
    _builder.newLineIfNotEmpty();
    {
      boolean _isPixelMapMode = this._utils_qvto.isPixelMapMode(it.getDiagram());
      if (_isPixelMapMode) {
        _builder.append(location);
        _builder.append(".setX(");
        _builder.append(x);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append(location);
        _builder.append(".setY(");
        _builder.append(y);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append(location);
        _builder.append(".setX(org.eclipse.gmf.runtime.diagram.ui.util.MeasurementUnitHelper.getMapMode(");
        _builder.append(viewVar);
        _builder.append(".getDiagram().getMeasurementUnit()).DPtoLP(");
        _builder.append(x);
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        _builder.append(location);
        _builder.append(".setY(org.eclipse.gmf.runtime.diagram.ui.util.MeasurementUnitHelper.getMapMode(");
        _builder.append(viewVar);
        _builder.append(".getDiagram().getMeasurementUnit()).DPtoLP(");
        _builder.append(y);
        _builder.append("));");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence offset(final GenLabel it, final String viewVar) {
    if (it instanceof GenExternalNodeLabel) {
      return _offset((GenExternalNodeLabel)it, viewVar);
    } else if (it instanceof GenLinkLabel) {
      return _offset((GenLinkLabel)it, viewVar);
    } else if (it != null) {
      return _offset(it, viewVar);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, viewVar).toString());
    }
  }
}
