/**
 * Copyright (c) 2010 CEA LIST
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Yann Tanguy (CEA LIST) - initial API and implementation
 */
package utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.papyrusgmfgenextension.SpecificLocatorExternalLabel;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@Singleton
@SuppressWarnings("all")
public class EditPartsUtils_qvto {
  public boolean hasSpecificLocator(final GenExternalNodeLabel it) {
    final Function1<SpecificLocatorExternalLabel, Boolean> _function = new Function1<SpecificLocatorExternalLabel, Boolean>() {
      @Override
      public Boolean apply(final SpecificLocatorExternalLabel v) {
        return Boolean.valueOf(v.getGenExternalNodeLabel().contains(it));
      }
    };
    int _size = IteratorExtensions.size(IteratorExtensions.<SpecificLocatorExternalLabel>filter(Iterators.<SpecificLocatorExternalLabel>filter(it.eResource().getAllContents(), SpecificLocatorExternalLabel.class), _function));
    return (_size != 0);
  }
  
  public String getSpecificLocator(final GenExternalNodeLabel it) {
    boolean _hasSpecificLocator = this.hasSpecificLocator(it);
    if (_hasSpecificLocator) {
      final Function1<SpecificLocatorExternalLabel, Boolean> _function = new Function1<SpecificLocatorExternalLabel, Boolean>() {
        @Override
        public Boolean apply(final SpecificLocatorExternalLabel v) {
          return Boolean.valueOf(v.getGenExternalNodeLabel().contains(it));
        }
      };
      return IteratorExtensions.<SpecificLocatorExternalLabel>head(IteratorExtensions.<SpecificLocatorExternalLabel>filter(Iterators.<SpecificLocatorExternalLabel>filter(it.eResource().getAllContents(), SpecificLocatorExternalLabel.class), _function)).getClasspath();
    }
    return null;
  }
  
  public List<GenExternalNodeLabel> getExternalLabelsWithoutSpecificLocator(final GenNode it) {
    final Function1<GenExternalNodeLabel, Boolean> _function = new Function1<GenExternalNodeLabel, Boolean>() {
      @Override
      public Boolean apply(final GenExternalNodeLabel l) {
        boolean _hasSpecificLocator = EditPartsUtils_qvto.this.hasSpecificLocator(l);
        return Boolean.valueOf((!_hasSpecificLocator));
      }
    };
    return IterableExtensions.<GenExternalNodeLabel>toList(IterableExtensions.<GenExternalNodeLabel>filter(Iterables.<GenExternalNodeLabel>filter(it.getLabels(), GenExternalNodeLabel.class), _function));
  }
  
  public List<GenExternalNodeLabel> getExternalLabelsWithSpecificLocator(final GenNode it) {
    final Function1<GenExternalNodeLabel, Boolean> _function = new Function1<GenExternalNodeLabel, Boolean>() {
      @Override
      public Boolean apply(final GenExternalNodeLabel l) {
        return Boolean.valueOf(EditPartsUtils_qvto.this.hasSpecificLocator(l));
      }
    };
    return IterableExtensions.<GenExternalNodeLabel>toList(IterableExtensions.<GenExternalNodeLabel>filter(Iterables.<GenExternalNodeLabel>filter(it.getLabels(), GenExternalNodeLabel.class), _function));
  }
}
