/**
 * Copyright (c) 2006, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package gmfgraph;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.papyrus.gmf.gmfgraph.DecorationFigure;
import org.eclipse.papyrus.gmf.gmfgraph.PolygonDecoration;
import org.eclipse.papyrus.gmf.gmfgraph.PolylineDecoration;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Instantiate and define attributes for DecorationFigures
 */
@Singleton
@SuppressWarnings("all")
public class Decoration {
  @Inject
  private gmfgraph.Runtime xptRuntime;
  
  @Inject
  private Attrs xptAttrs;
  
  @Inject
  private gmfgraph.attr.Decoration xptDecorationAttrs;
  
  protected CharSequence _Instantiate(final DecorationFigure it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _newInstance = this.xptRuntime.newInstance(it, figureVarName);
    _builder.append(_newInstance);
    _builder.newLineIfNotEmpty();
    CharSequence _Init = this.xptAttrs.Init(it, figureVarName);
    _builder.append(_Init);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _Instantiate(final PolylineDecoration it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _newInstance = this.xptRuntime.newInstance(it, figureVarName);
    _builder.append(_newInstance);
    _builder.newLineIfNotEmpty();
    CharSequence _polylineAttrs = this.xptDecorationAttrs.polylineAttrs(it, figureVarName);
    _builder.append(_polylineAttrs);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  /**
   * Copy of above template for PolylineDecoration,
   * just because PolygonDecoration doesn't extend PolylineDecoration in draw2d and gmfgraph
   */
  protected CharSequence _Instantiate(final PolygonDecoration it, final String figureVarName) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _newInstance = this.xptRuntime.newInstance(it, figureVarName);
    _builder.append(_newInstance);
    _builder.newLineIfNotEmpty();
    CharSequence _polylineAttrs = this.xptDecorationAttrs.polylineAttrs(it, figureVarName);
    _builder.append(_polylineAttrs);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence Instantiate(final DecorationFigure it, final String figureVarName) {
    if (it instanceof PolygonDecoration) {
      return _Instantiate((PolygonDecoration)it, figureVarName);
    } else if (it instanceof PolylineDecoration) {
      return _Instantiate((PolylineDecoration)it, figureVarName);
    } else if (it != null) {
      return _Instantiate(it, figureVarName);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it, figureVarName).toString());
    }
  }
}
