/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.outline.emftree;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.contentoutline.IPapyrusContentOutlinePage;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.outline.emftree.internal.OutlineDragAdapter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;

public class ContentOutline
extends ContentOutlinePage
implements IMenuListener,
IPapyrusContentOutlinePage {
    protected EditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected TreeViewer contentOutlineViewer;
    private IEditorSite editorSite;

    public ContentOutline() {
    }

    public ContentOutline(IEditorSite editorSite, EditingDomain editingDomain, ComposedAdapterFactory adapterFactory) {
        this.editorSite = editorSite;
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
    }

    public ContentOutline(IEditorSite editorSite, EditingDomain editingDomain) {
        this.editorSite = editorSite;
        this.editingDomain = editingDomain;
        this.initAdapterFactory();
    }

    public void init(IMultiDiagramEditor multiEditor) throws BackboneException {
        this.editorSite = multiEditor.getEditorSite();
        try {
            this.editingDomain = (EditingDomain)multiEditor.getServicesRegistry().getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            throw new BackboneException("Can't get TransactionalEditingDomain", (Throwable)e);
        }
        this.initAdapterFactory();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.contentOutlineViewer = this.getTreeViewer();
        this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.contentOutlineViewer.setInput((Object)this.editingDomain.getResourceSet());
        this.createContextMenuFor((StructuredViewer)this.contentOutlineViewer);
        if (!this.editingDomain.getResourceSet().getResources().isEmpty()) {
            this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
        }
    }

    protected void initDragAndDrop() {
        int ops = 7;
        OutlineDragAdapter dragAdapter = new OutlineDragAdapter((ISelectionProvider)this.contentOutlineViewer);
        this.contentOutlineViewer.addDragSupport(ops, dragAdapter.getSupportedDragTransfers(), (DragSourceListener)dragAdapter);
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        if (this.getActionBarContributor() != null) {
            this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
        }
    }

    private EditingDomainActionBarContributor getActionBarContributor() {
        if (this.editorSite.getActionBarContributor() instanceof EditingDomainActionBarContributor) {
            return (EditingDomainActionBarContributor)this.editorSite.getActionBarContributor();
        }
        return null;
    }

    private void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getEditorSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(this.editingDomain, (Viewer)viewer));
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    private IEditorSite getEditorSite() {
        return this.editorSite;
    }

    private void initAdapterFactory() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new UMLItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }
}

