/**
 * Copyright (c) 2008, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - [244419] custom parsers
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package parsers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class CustomParser {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private ParsersUtil _parsersUtil;
  
  public CharSequence className(final org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _classNameCustomParser = this._parsersUtil.classNameCustomParser(it);
    _builder.append(_classNameCustomParser);
    return _builder;
  }
  
  public CharSequence packageName(final org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageNameCustomParser = this._parsersUtil.packageNameCustomParser(it);
    _builder.append(_packageNameCustomParser);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence Main(final org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getHolder().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _body = this.body(it);
    _builder.append(_body, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _additions = this.additions(it);
    _builder.append(_additions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence additions(final org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence extendsList(final org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  public CharSequence implementsList(final org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    _builder.append("implements org.eclipse.gmf.runtime.common.ui.services.parser.IParser");
    return _builder;
  }
  
  /**
   * As this is a borderblate class generator, there are no reasons to split it to per-method pieces.
   */
  public CharSequence body(final org.eclipse.papyrus.gmf.codegen.gmfgen.CustomParser it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getEditString(org.eclipse.core.runtime.IAdaptable element, int flags) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return \"\";");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus isValidEditString(org.eclipse.core.runtime.IAdaptable element, String editString) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// TODO change to EDITABLE_STATUS as appropriate");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus.UNEDITABLE_STATUS;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gmf.runtime.common.core.command.ICommand getParseCommand(org.eclipse.core.runtime.IAdaptable element, String newString, int flags) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// TODO");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("throw new UnsupportedOperationException(); ");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_3);
    _builder.newLineIfNotEmpty();
    _builder.append("public String getPrintString(org.eclipse.core.runtime.IAdaptable element, int flags) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return \"\";");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_4);
    _builder.newLineIfNotEmpty();
    _builder.append("public boolean isAffectingEvent(Object event, int flags) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return false;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_5);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.jface.text.contentassist.IContentAssistProcessor getCompletionProcessor(org.eclipse.core.runtime.IAdaptable element) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
