/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.wizards;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.emf.facet.efacet.Facet;
import org.eclipse.papyrus.emf.facet.efacet.FacetSet;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.IQueryCreationPagePartRegistry;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.exported.wizard.IFacetChildrenWizard;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.exported.wizard.IQueryCreationPagePart;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.wizards.pages.AbstractFacetWizardPage;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.wizards.pages.CreateQueryWizardPage;

@Deprecated
public abstract class AbstractAddFacetChildrenWizard
extends Wizard
implements IFacetChildrenWizard {
    private final ISelection selection;
    private final EditingDomain editingDomain;
    private final WizardDialog dialog;
    private FacetSet facetSet;
    private Facet facet;
    private final Map<String, IQueryCreationPagePart> queryTypeNameToQueryCreationPage;
    private AbstractFacetWizardPage facetCreationPage;
    private CreateQueryWizardPage queryCreationPage;

    public AbstractAddFacetChildrenWizard(ISelection selection, EditingDomain editingDomain) {
        this.selection = selection;
        this.editingDomain = editingDomain;
        this.initializeSelection();
        this.queryTypeNameToQueryCreationPage = IQueryCreationPagePartRegistry.INSTANCE.getRegisteredWizardPageParts();
        this.dialog = new WizardDialog(this.getShell(), (IWizard)this);
        this.addQueryCreationPage();
    }

    protected void addQueryCreationPage() {
        this.queryCreationPage = new CreateQueryWizardPage(this.queryTypeNameToQueryCreationPage, this.getFacetSet(), this.facet);
    }

    private void initializeSelection() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof FacetSet) {
                this.facetSet = (FacetSet)obj;
            } else if (obj instanceof Facet) {
                this.facetSet = ((Facet)obj).getFacetSet();
                this.facet = (Facet)obj;
            }
        }
    }

    public void addPages() {
        if (this.facetCreationPage != null) {
            this.addPage((IWizardPage)this.facetCreationPage);
        }
        if (this.queryCreationPage != null) {
            this.queryCreationPage.canChangeCanBeCached(false);
            this.queryCreationPage.canChangeHasSideEffect(false);
            this.queryCreationPage.canChangeLowerBound(false);
            this.queryCreationPage.canChangeUpperBound(false);
            this.queryCreationPage.canChangeQueryName(false);
            this.queryCreationPage.setFacetSet(this.getFacetSet());
            this.addPage((IWizardPage)this.queryCreationPage);
        }
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.queryCreationPage && this.queryCreationPage.isPageComplete();
    }

    @Override
    public int open() {
        if (this.dialog != null) {
            return this.dialog.open();
        }
        return 1;
    }

    @Override
    public void setFacet(Facet facet) {
        this.facetCreationPage.setFacet(facet);
    }

    @Override
    public void setChildrenName(String referenceName) {
        this.facetCreationPage.setChildrenName(referenceName);
    }

    @Override
    public void setUpperBound(int upperBound) {
        this.facetCreationPage.setUpperBound(upperBound);
    }

    @Override
    public void setLowerBound(int lowerBound) {
        this.facetCreationPage.setLowerBound(lowerBound);
    }

    @Override
    public void setType(EClass type) {
        this.facetCreationPage.setType(type);
    }

    @Override
    public void canChangeFacet(boolean canChange) {
        this.facetCreationPage.canChangeParentName(canChange);
    }

    @Override
    public void canChangeChildrenName(boolean canChange) {
        this.facetCreationPage.canChangeChildrenName(canChange);
    }

    @Override
    public void canChangeUpperBound(boolean canChange) {
        this.facetCreationPage.canChangeUpperBound(canChange);
    }

    @Override
    public void canChangeLowerBound(boolean canChange) {
        this.facetCreationPage.canChangeLowerBound(canChange);
    }

    @Override
    public void canChangeType(boolean canChange) {
        this.facetCreationPage.canChangeType(canChange);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected final FacetSet getFacetSet() {
        return this.facetSet;
    }

    protected final CreateQueryWizardPage getQueryCreationPage() {
        return this.queryCreationPage;
    }

    protected void setFacetCreationPage(AbstractFacetWizardPage facetCreationPage) {
        this.facetCreationPage = facetCreationPage;
    }

    protected ISelection getSelection() {
        return this.selection;
    }

    protected Map<String, IQueryCreationPagePart> getQueryTypeNameToQueryCreationPage() {
        return this.queryTypeNameToQueryCreationPage;
    }

    protected AbstractFacetWizardPage getFacetCreationPage() {
        return this.facetCreationPage;
    }
}

