/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers.LocalProfileIndex;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.messages.Messages;
import org.eclipse.papyrus.uml.types.core.advices.stereotypepropertyreferenceedgeadvice.StereotypePropertyReferenceEdgeAdviceConfiguration;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypePropertyReferenceEdgeAdviceCustomValidator
extends CustomModelChecker.SwitchValidator {
    public StereotypePropertyReferenceEdgeAdviceCustomValidator(String nsURI) {
        super(nsURI);
    }

    public void validate(StereotypePropertyReferenceEdgeAdviceConfiguration stereotypeReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String stereotypeName = stereotypeReference.getStereotypeQualifiedName();
        if (stereotypeName != null && !stereotypeName.isBlank()) {
            String featureName = stereotypeReference.getFeatureToSet();
            if (this.validateStereotypeName(stereotypeReference, stereotypeName, diagnostics, context) && featureName != null && !featureName.isBlank()) {
                Stereotype stereotype = this.getStereotype(stereotypeReference, stereotypeName, context);
                this.validateFeatureToSet(stereotypeReference, stereotype, featureName, diagnostics, context);
            }
        }
    }

    private boolean validateStereotypeName(StereotypePropertyReferenceEdgeAdviceConfiguration stereotypeReference, String qualifiedName, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        Stereotype stereotype = this.getStereotype(stereotypeReference, qualifiedName, context);
        boolean bl = result = stereotype != null;
        if (!result) {
            diagnostics.add(this.createDiagnostic(4, (EObject)stereotypeReference, this.format(Messages.StereotypePropertyReferenceEdgeAdviceCustomValidator_0, context, new Object[]{stereotypeReference})));
        }
        return result;
    }

    private Stereotype getStereotype(StereotypePropertyReferenceEdgeAdviceConfiguration stereotypeReference, String qualifiedName, Map<Object, Object> context) {
        LocalProfileIndex index = LocalProfileIndex.getInstance((EObject)stereotypeReference, context);
        return index.getStereotype(qualifiedName, (EObject)stereotypeReference);
    }

    private void validateFeatureToSet(StereotypePropertyReferenceEdgeAdviceConfiguration stereotypeReference, Stereotype stereotype, String featureName, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Property property = stereotype.getAttribute(featureName, null);
        if (property == null) {
            diagnostics.add(this.createDiagnostic(4, (EObject)stereotypeReference, this.format(Messages.StereotypePropertyReferenceEdgeAdviceCustomValidator_1, context, new Object[]{stereotypeReference, featureName})));
        } else if (property.getType() == null) {
            diagnostics.add(this.createDiagnostic(4, (EObject)stereotypeReference, this.format(Messages.StereotypePropertyReferenceEdgeAdviceCustomValidator_2, context, new Object[]{stereotypeReference, featureName})));
        }
    }
}

