/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

public class DataCell {
    protected int columnPosition;
    protected int rowPosition;
    protected int columnSpan;
    protected int rowSpan;

    public DataCell(int columnPosition, int rowPosition) {
        this(columnPosition, rowPosition, 1, 1);
    }

    public DataCell(int columnPosition, int rowPosition, int columnSpan, int rowSpan) {
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
        this.columnSpan = columnSpan;
        this.rowSpan = rowSpan;
    }

    public int getColumnPosition() {
        return this.columnPosition;
    }

    public int getRowPosition() {
        return this.rowPosition;
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public boolean isSpannedCell() {
        return this.columnSpan > 1 || this.rowSpan > 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataCell other = (DataCell)obj;
        if (this.columnPosition != other.columnPosition) {
            return false;
        }
        if (this.columnSpan != other.columnSpan) {
            return false;
        }
        if (this.rowPosition != other.rowPosition) {
            return false;
        }
        return this.rowSpan == other.rowSpan;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.columnPosition;
        result = 31 * result + this.columnSpan;
        result = 31 * result + this.rowPosition;
        result = 31 * result + this.rowSpan;
        return result;
    }
}

