/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.preferences.Activator;
import org.eclipse.papyrus.infra.gmfdiag.preferences.messages.Messages;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.AbstractGroup;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.editor.CLabelBooleanFieldEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class OrderedLabelGroup
extends AbstractGroup {
    private Map<String, String> myRoles = new LinkedHashMap<String, String>();

    public OrderedLabelGroup(Composite parent, String preferenceKey, DialogPage dialogPage, Map<String, String> roles) {
        super(parent, preferenceKey, dialogPage);
        this.myRoles = roles;
        this.createContent(parent);
    }

    public OrderedLabelGroup(Composite parent, String preferenceKey, DialogPage dialogPage, List<String> roles) {
        super(parent, preferenceKey, dialogPage);
        for (String role : roles) {
            this.myRoles.put(role, "");
        }
        this.createContent(parent);
    }

    protected void createContent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.LabelGroup_Labels_To_Display);
        for (String role : this.myRoles.keySet()) {
            String key = PreferencesConstantsHelper.getLabelElementConstant((String)this.getKey(), (String)role, (int)20);
            Image im = null;
            String iconPath = this.myRoles.get(role);
            if (iconPath != null && !iconPath.isEmpty()) {
                try {
                    im = ImageDescriptor.createFromURL((URL)new URL(iconPath)).createImage();
                }
                catch (MalformedURLException e) {
                    Activator.log.error("I can't find the following image " + this.myRoles.get(role), (Throwable)e);
                }
            }
            CLabelBooleanFieldEditor editor = new CLabelBooleanFieldEditor(key, role, im, (Composite)group);
            editor.setPage(this.dialogPage);
            this.addFieldEditor((FieldEditor)editor);
        }
    }
}

