/*
 * Decompiled with CFR 0.152.
 */
package xpt.navigator;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common_qvto;

@Singleton
public class Utils_qvto {
    @Inject
    @Extension
    private Common_qvto _common_qvto;

    public int getMaxVisualID(GenNavigator navigator) {
        Functions.Function1<GenCommonBase, Integer> _function = new Functions.Function1<GenCommonBase, Integer>(){

            public Integer apply(GenCommonBase n) {
                return n.getVisualID();
            }
        };
        return ((GenCommonBase)IterableExtensions.last((Iterable)IterableExtensions.sortBy(this.getNavigatorNodes(navigator), (Functions.Function1)_function))).getVisualID();
    }

    public Iterable<GenCommonBase> getNavigatorContainerNodes(final GenNavigator navigator) {
        Functions.Function1<GenCommonBase, Boolean> _function = new Functions.Function1<GenCommonBase, Boolean>(){

            public Boolean apply(GenCommonBase n) {
                return Utils_qvto.this._common_qvto.notEmpty(Utils_qvto.this.getChildReferencesFrom(navigator, n));
            }
        };
        return IterableExtensions.filter(this.getNavigatorNodes(navigator), (Functions.Function1)_function);
    }

    public Iterable<GenCommonBase> getNavigatorContainedNodes(final GenNavigator navigator) {
        Functions.Function1<GenCommonBase, Boolean> _function = new Functions.Function1<GenCommonBase, Boolean>(){

            public Boolean apply(GenCommonBase n) {
                return Utils_qvto.this._common_qvto.notEmpty(Utils_qvto.this.getChildReferencesTo(navigator, n));
            }
        };
        return IterableExtensions.filter(this.getNavigatorNodes(navigator), (Functions.Function1)_function);
    }

    public Iterable<GenCommonBase> getNavigatorNodes(GenNavigator navigator) {
        LinkedList result = CollectionLiterals.newLinkedList();
        result.addAll(navigator.getEditorGen().getDiagram().getAllContainers());
        result.addAll(navigator.getEditorGen().getDiagram().getLinks());
        Functions.Function1<GenCommonBase, Integer> _function = new Functions.Function1<GenCommonBase, Integer>(){

            public Integer apply(GenCommonBase n) {
                return n.getVisualID();
            }
        };
        return IterableExtensions.sortBy((Iterable)result, (Functions.Function1)_function);
    }

    public Set<String> getGroupNames(Iterable<GenNavigatorChildReference> refs) {
        Functions.Function1<GenNavigatorChildReference, Boolean> _function = new Functions.Function1<GenNavigatorChildReference, Boolean>(){

            public Boolean apply(GenNavigatorChildReference ref) {
                return ref.isInsideGroup();
            }
        };
        Functions.Function1<GenNavigatorChildReference, String> _function_1 = new Functions.Function1<GenNavigatorChildReference, String>(){

            public String apply(GenNavigatorChildReference ref) {
                return ref.getGroupName();
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(refs, (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    public GenNavigatorChildReference getNavigatorReference(final String groupName, Iterable<GenNavigatorChildReference> childReferences) {
        Functions.Function1<GenNavigatorChildReference, Boolean> _function = new Functions.Function1<GenNavigatorChildReference, Boolean>(){

            public Boolean apply(GenNavigatorChildReference r) {
                String _groupName = r.getGroupName();
                return Objects.equal((Object)_groupName, (Object)groupName);
            }
        };
        return (GenNavigatorChildReference)IterableExtensions.findFirst(childReferences, (Functions.Function1)_function);
    }

    public Iterable<GenNavigatorChildReference> getChildReferencesFrom(GenNavigator navigator, final GenCommonBase parent) {
        Iterable _xifexpression = null;
        if (parent == null) {
            Functions.Function1<GenNavigatorChildReference, Boolean> _function = new Functions.Function1<GenNavigatorChildReference, Boolean>(){

                public Boolean apply(GenNavigatorChildReference r) {
                    GenCommonBase _parent = r.getParent();
                    return _parent == null;
                }
            };
            _xifexpression = IterableExtensions.filter((Iterable)navigator.getChildReferences(), (Functions.Function1)_function);
        } else {
            Functions.Function1<GenNavigatorChildReference, Boolean> _function_1 = new Functions.Function1<GenNavigatorChildReference, Boolean>(){

                public Boolean apply(GenNavigatorChildReference r) {
                    return r.getParent() != null && parent.getVisualID() == r.getParent().getVisualID();
                }
            };
            _xifexpression = IterableExtensions.filter((Iterable)navigator.getChildReferences(), (Functions.Function1)_function_1);
        }
        return _xifexpression;
    }

    public Iterable<GenNavigatorChildReference> getChildReferencesTo(GenNavigator navigator, final GenCommonBase child) {
        Functions.Function1<GenNavigatorChildReference, Boolean> _function = new Functions.Function1<GenNavigatorChildReference, Boolean>(){

            public Boolean apply(GenNavigatorChildReference r) {
                int _visualID_1;
                int _visualID = child.getVisualID();
                return _visualID == (_visualID_1 = r.getChild().getVisualID());
            }
        };
        return IterableExtensions.filter((Iterable)navigator.getChildReferences(), (Functions.Function1)_function);
    }

    public GenNavigatorChildReference getDiagramTopReference(final GenNavigator navigator) {
        Functions.Function1<GenNavigatorChildReference, Boolean> _function = new Functions.Function1<GenNavigatorChildReference, Boolean>(){

            public Boolean apply(GenNavigatorChildReference cr) {
                GenCommonBase _parent = cr.getParent();
                return _parent == null;
            }
        };
        Functions.Function1<GenNavigatorChildReference, Boolean> _function_1 = new Functions.Function1<GenNavigatorChildReference, Boolean>(){

            public Boolean apply(GenNavigatorChildReference cr) {
                GenCommonBase _child = cr.getChild();
                GenDiagram _diagram = navigator.getEditorGen().getDiagram();
                return Objects.equal((Object)_child, (Object)_diagram);
            }
        };
        return (GenNavigatorChildReference)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)navigator.getChildReferences(), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    public boolean isStringFeature(GenFeature feature) {
        String _name = feature.getEcoreFeature().getEType().getName();
        return Objects.equal((Object)_name, (Object)"EString");
    }
}

