/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.services.internal;

import org.eclipse.papyrus.infra.core.services.BadStateException;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.services.internal.PojoServiceEntry;

public class ServiceAdapterEntry
extends PojoServiceEntry {
    private IService serviceAdapter;

    public ServiceAdapterEntry(ServiceDescriptor serviceDescriptor, Object serviceInstance, IService serviceAdapter) {
        super(serviceDescriptor, serviceInstance);
        this.serviceAdapter = serviceAdapter;
    }

    @Override
    public void initService(ServicesRegistry servicesRegistry) throws ServiceException {
        this.checkAdapter();
        this.serviceAdapter.init(servicesRegistry);
        super.initService(servicesRegistry);
    }

    protected final void checkAdapter() throws ServiceException {
        if (this.serviceAdapter == null) {
            throw new BadStateException("Service is disposed", this.state, this.serviceDescriptor);
        }
    }

    @Override
    public void startService() throws ServiceException {
        this.checkAdapter();
        this.serviceAdapter.startService();
        super.startService();
    }

    @Override
    public void disposeService() throws ServiceException {
        if (this.serviceAdapter != null) {
            this.serviceAdapter.disposeService();
            this.serviceAdapter = null;
        }
        super.disposeService();
    }
}

