/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.editpoliciesstates.view;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.gmf.editpoliciesstates.view.EditpolicyLabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.dnd.policy.CustomizableDropEditPolicy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class EditPoliciesStateView
extends ViewPart {
    private ArrayList<EditPolicyDescriptor> editPolicyList = new ArrayList();
    private ISelectionListener myEditPartlistener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                Object[] policiesValue = null;
                Object selectedobject = ((IStructuredSelection)selection).getFirstElement();
                if (selectedobject instanceof GraphicalEditPart) {
                    GraphicalEditPart graphicalEP = (GraphicalEditPart)selectedobject;
                    Field policiesFiled = null;
                    try {
                        policiesFiled = AbstractEditPart.class.getDeclaredField("policies");
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    policiesFiled.setAccessible(true);
                    try {
                        policiesValue = (Object[])policiesFiled.get(graphicalEP);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    EditPoliciesStateView.this.editPolicyList.clear();
                    int i = 0;
                    while (i < policiesValue.length) {
                        EditPolicyDescriptor epd = new EditPolicyDescriptor();
                        if (policiesValue[i] instanceof String) {
                            epd.role = (String)policiesValue[i];
                            EditPoliciesStateView.this.editPolicyList.add(epd);
                        }
                        if (policiesValue[i + 1] instanceof EditPolicy) {
                            epd.policy = (EditPolicy)policiesValue[i + 1];
                        }
                        i += 2;
                    }
                    if (EditPoliciesStateView.this.viewer != null) {
                        EditPoliciesStateView.this.viewer.setInput(EditPoliciesStateView.this.editPolicyList);
                    }
                }
            }
        }
    };
    private TreeViewer viewer;

    public void setFocus() {
        TreeViewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().setFocus();
        }
    }

    protected Tree createTree(Composite parent) {
        Tree tree = new Tree(parent, 66306);
        tree.setLinesVisible(true);
        return tree;
    }

    protected TreeViewer getViewer() {
        return this.viewer;
    }

    public EditPoliciesStateView() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener(this.myEditPartlistener);
    }

    protected void createColumns() {
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        TreeColumn tcName = new TreeColumn(this.viewer.getTree(), 16384);
        tcName.setText("Name");
        tcName.setWidth(200);
        TreeColumn tcDescription = new TreeColumn(this.viewer.getTree(), 16384);
        tcDescription.setText("Description");
        tcDescription.setWidth(800);
    }

    public void createPartControl(Composite parent) {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)this.getClearViewAction());
        this.viewer = new TreeViewer(this.createTree(parent));
        this.viewer.setContentProvider(this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.createColumns();
    }

    protected ITableLabelProvider getLabelProvider() {
        return new EditpolicyLabelProvider();
    }

    protected Action getClearViewAction() {
        return new Action(){

            public void run() {
                EditPoliciesStateView.this.clear();
            }

            public boolean isEnabled() {
                return true;
            }

            public String getToolTipText() {
                return this.getText();
            }

            public String getText() {
                return "Clear the view";
            }
        };
    }

    protected IContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length != 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof EditPolicyDescriptor && ((EditPolicyDescriptor)parentElement).policy != null && ((EditPolicyDescriptor)parentElement).policy instanceof CustomizableDropEditPolicy) {
                    try {
                        Field defaultDropEditPolicyField = CustomizableDropEditPolicy.class.getDeclaredField("defaultDropEditPolicy");
                        Field defaultCreationEditPolicyField = CustomizableDropEditPolicy.class.getDeclaredField("defaultCreationEditPolicy");
                        defaultDropEditPolicyField.setAccessible(true);
                        defaultCreationEditPolicyField.setAccessible(true);
                        EditPolicyDescriptor edp1 = new EditPolicyDescriptor();
                        EditPolicyDescriptor edp2 = new EditPolicyDescriptor();
                        edp1.policy = (EditPolicy)defaultDropEditPolicyField.get(((EditPolicyDescriptor)parentElement).policy);
                        edp2.policy = (EditPolicy)defaultCreationEditPolicyField.get(((EditPolicyDescriptor)parentElement).policy);
                        edp1.role = "defaultDropEditPolicy";
                        edp2.role = "defaultCreationEditPolicy";
                        Object[] result = new Object[]{edp1, edp2};
                        return result;
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                return new Object[0];
            }
        };
    }

    public void dispose() {
        super.dispose();
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        selectionService.removeSelectionListener(this.myEditPartlistener);
        this.clear();
    }

    private void clear() {
        this.editPolicyList.clear();
    }

    class EditPolicyDescriptor {
        public String role = "NO ROLE";
        public EditPolicy policy = null;

        EditPolicyDescriptor() {
        }
    }
}

