/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocumentPackage;
import org.eclipse.papyrus.infra.textedit.ui.Activator;
import org.eclipse.papyrus.infra.textedit.ui.internal.messages.Messages;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForIEvaluationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class RenameTextDocumentEditorHandler
extends AbstractHandler {
    private static final String NEW_TEXTDOCUMENT_NAME = Messages.RenameTextDocumentEditorHandler_NewName;
    private static final String RENAME_AN_EXISTING_TEXTDOCUMENT = Messages.RenameTextDocumentEditorHandler_RenameAnExistingDocument;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.executeTransaction(event);
        return null;
    }

    private void executeTransaction(ExecutionEvent event) {
        TransactionalEditingDomain domain = this.getEditingDomain(event);
        TextDocument textDocument = this.lookupTextDocument(event);
        if (textDocument == null || domain == null) {
            return;
        }
        String currentName = textDocument.getName();
        String newName = null;
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), RENAME_AN_EXISTING_TEXTDOCUMENT, NEW_TEXTDOCUMENT_NAME, currentName, null);
        if (dialog.open() == 0) {
            newName = dialog.getValue();
        }
        if (newName != null && !newName.equals(currentName)) {
            SetRequest request = new SetRequest(domain, (EObject)textDocument, (EStructuralFeature)TextDocumentPackage.eINSTANCE.getTextDocument_Name(), (Object)newName);
            IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)textDocument);
            Command command = null;
            if (commandProvider != null) {
                command = GMFtoEMFCommandWrapper.wrap((ICommand)commandProvider.getEditCommand((IEditCommandRequest)request));
            }
            if (command != null) {
                domain.getCommandStack().execute(command);
            }
        }
    }

    private IEvaluationContext getIEvaluationContext(ExecutionEvent event) {
        if (event.getApplicationContext() instanceof IEvaluationContext) {
            return (IEvaluationContext)event.getApplicationContext();
        }
        return null;
    }

    private TransactionalEditingDomain getEditingDomain(ExecutionEvent event) {
        TransactionalEditingDomain domain = null;
        try {
            domain = ServiceUtilsForHandlers.getInstance().getTransactionalEditingDomain((Object)event);
        }
        catch (ServiceException e) {
            Activator.log.error("EditingDomain not found", (Throwable)e);
        }
        return domain;
    }

    private TextDocument lookupTextDocument(ExecutionEvent event) {
        TextDocument textDocument = null;
        IEvaluationContext context = this.getIEvaluationContext(event);
        if (context != null) {
            try {
                IEditorPart editor = (IEditorPart)ServiceUtilsForIEvaluationContext.getInstance().getService(IMultiDiagramEditor.class, (Object)context);
                textDocument = (TextDocument)editor.getAdapter(TextDocument.class);
            }
            catch (ServiceException e) {
                Activator.log.error("The current editor can't be found", (Throwable)e);
            }
        }
        return textDocument;
    }

    private TextDocument lookupTextDocument(IEvaluationContext context) throws ServiceException {
        IEditorPart editor = (IEditorPart)ServiceUtilsForIEvaluationContext.getInstance().getService(IMultiDiagramEditor.class, (Object)context);
        TextDocument textDocument = (TextDocument)editor.getAdapter(TextDocument.class);
        return textDocument;
    }

    public void setEnabled(Object evaluationContext) {
        boolean enable = false;
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext context = (IEvaluationContext)evaluationContext;
            try {
                enable = this.lookupTextDocument(context) != null;
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        this.setBaseEnabled(enable);
    }
}

